/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.TextInput;
import malik.emulator.io.j2me.input.CharDestination;
import malik.emulator.media.graphics.RasterCanvas;

public class TextField
extends Item
implements Input {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int CONSTRAINT_MASK = 65535;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    private boolean controlFocused;
    private boolean pointerFocused;
    private int scrollPosition;
    private Font font = Font.getFont(1);
    private TextInput input;
    private CommandListener capabilities;

    public TextField(String label, String text, int maxLength, int constraints) {
        this(0, -1, label, null, null, null, text, maxLength, constraints);
    }

    public TextField(int layout, int lockedWidth, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener, String text, int maxLength, int constraints) {
        super(layout, lockedWidth, -1, label, Displayable.concatCommands(commands, TextInput.getAdditionalCapabilitiesCommands(constraints, false)), defaultCommand, listener);
        TextInput input;
        this.input = input = new TextInput(text, maxLength, constraints);
        TextInput textInput = input;
        textInput.getClass();
        this.capabilities = textInput.new TextInput.AdditionalCapabilities(new Destination(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String src, int position) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src, position);
            if (src.length() > 0) {
                this.notifyPaint();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] src, int offset, int length, int position) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src, offset, length, position);
            if (length > 0) {
                this.notifyPaint();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.delete(offset, length);
            if (length > 0) {
                this.notifyPaint();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.setString(src);
            this.notifyPaint();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] src, int offset, int length) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.setChars(src, offset, length);
            this.notifyPaint();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int oldConstraints = input.getConstraints();
            if (oldConstraints != constraints) {
                input.setConstraints(oldConstraints);
                this.removeCommands(TextInput.getAdditionalCapabilitiesCommands(oldConstraints, false));
                this.addCommands(TextInput.getAdditionalCapabilitiesCommands(constraints, false));
                this.notifyPaint();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public void setInitialInputMode(String characterSubset) {
        this.input.setInitialInputMode(characterSubset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maxLength) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int result;
            if (input.getMaxSize() != maxLength) {
                result = input.setMaxSize(maxLength);
                this.notifyPaint();
            } else {
                result = maxLength;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    public int size() {
        return this.input.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] dst) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int result = input.getChars(dst);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    public int getConstraints() {
        return this.input.getConstraints();
    }

    public int getCaretPosition() {
        return this.input.getCaretPosition();
    }

    public int getMaxSize() {
        return this.input.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            String result = input.getString();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        TextInput input;
        Font font = this.font;
        render.setFont(font);
        TextInput textInput = input = this.input;
        synchronized (input) {
            boolean cfocused = this.controlFocused;
            int a = cfocused ? ((input.getConstraints() & 0x20000) != 0 ? 3 : 1) : 0;
            render.setColor(RasterCanvas.getSystemColor((int)(a + 32)));
            int s = font.getHeight();
            render.drawElementOfGUI(8, a, 0, 0, 0, contentWidth, s + 4);
            render.translate(2, 2);
            render.clipRect(0, 0, contentWidth - 4, s);
            char[] text = input.getChars();
            int scrollPosition = this.scrollPosition;
            render.drawChars(text, 0, input.getLength(), -scrollPosition + 1, 0, 20);
            if (cfocused) {
                int x = font.charsWidth(text, 0, input.getCaretPosition()) - scrollPosition;
                render.drawLine(x, 0, x, s - 1);
            }
            // ** MonitorExit[var12_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyPressed(int key, int charCode) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.keyPressed(key, charCode);
            if (input.isChanged()) {
                this.correctScrollPosition();
                super.notifyStateChanged();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyRepeated(int key, int charCode) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.keyPressed(key, charCode);
            if (input.isChanged()) {
                this.correctScrollPosition();
                super.notifyStateChanged();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    void onKeyReleased(int key) {
        this.input.keyReleased(key);
    }

    void onContentPointerPressed(int x, int y, int button) {
        this.pointerFocused = true;
        this.pointerHandle(this.scrollPosition + x - 2);
    }

    void onContentPointerDragged(int x, int y) {
        this.pointerHandle(this.scrollPosition + x - 2);
    }

    void onContentPointerReleased(int x, int y, int button) {
        this.pointerFocused = false;
    }

    void onCommandAction(Command command) {
        if (TextInput.isAdditionalCapabilitiesCommand(command)) {
            this.capabilities.commandAction(command, this.getOwner());
            return;
        }
        super.onCommandAction(command);
    }

    void onTraverseOut() {
        this.controlFocused = false;
        this.notifyPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean cfocused = this.controlFocused;
        this.controlFocused = true;
        if (!cfocused) {
            this.notifyPaint();
        }
        if (this.pointerFocused) {
            return true;
        }
        switch (direction) {
            case 1: 
            case 6: {
                return !cfocused;
            }
            case 2: {
                TextInput input;
                boolean result = false;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    if (!cfocused) {
                        input.setCaretPosition(input.getLength());
                        this.correctScrollPosition();
                        result = true;
                    } else {
                        int caretPosition = input.getCaretPosition();
                        if (caretPosition > 0) {
                            input.setCaretPosition(caretPosition - 1);
                            this.correctScrollPosition();
                            result = true;
                        }
                    }
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    return result;
                }
            }
            case 5: {
                TextInput input;
                boolean result = false;
                TextInput textInput = input = this.input;
                synchronized (input) {
                    if (!cfocused) {
                        input.setCaretPosition(0);
                        this.correctScrollPosition();
                        result = true;
                    } else {
                        int caretPosition = input.getCaretPosition();
                        if (caretPosition < input.getLength()) {
                            input.setCaretPosition(caretPosition + 1);
                            this.correctScrollPosition();
                            result = true;
                        }
                    }
                    // ** MonitorExit[var9_11] (shouldn't be in output)
                    return result;
                }
            }
        }
        return true;
    }

    boolean keyHandling(int key) {
        switch (key) {
            default: {
                return false;
            }
            case 8: 
            case 16: 
            case 32: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 160: 
            case 161: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
        }
        return true;
    }

    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        return 128;
    }

    int getPreferredContentHeight(int contentWidth) {
        return this.font.getHeight() + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pointerHandle(int x) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            int caretPosition;
            block5: {
                Font font = this.font;
                char[] text = input.getChars();
                int length = input.getLength();
                int w1 = 0;
                int i = 1;
                while (i <= length) {
                    int w2 = font.charsWidth(text, 0, i);
                    if (x >= w1 && x < w2) {
                        caretPosition = x - w1 <= w2 - x ? i - 1 : i;
                        break block5;
                    }
                    w1 = w2;
                    ++i;
                }
                caretPosition = length;
            }
            input.setCaretPosition(caretPosition);
            this.correctScrollPosition();
            // ** MonitorExit[var10_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(char src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src);
            if (input.isChanged()) {
                this.correctScrollPosition();
                super.notifyStateChanged();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String src) {
        TextInput input;
        TextInput textInput = input = this.input;
        synchronized (input) {
            input.insert(src);
            if (input.isChanged()) {
                this.correctScrollPosition();
                super.notifyStateChanged();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void correctScrollPosition() {
        int size;
        int scrollPosition;
        TextInput input = this.input;
        int charsWidth = this.font.charsWidth(input.getChars(), 0, input.getCaretPosition());
        if (charsWidth < (scrollPosition = this.scrollPosition) + (size = super.getPreferredWidth()) / 4 || charsWidth > scrollPosition + 3 * size / 4) {
            this.scrollPosition = Math.max(charsWidth - size / 2, 0);
        }
        this.notifyPaint();
    }

    private void addCommands(Command[] commands) {
        int len = commands.length;
        int i = 0;
        while (i < len) {
            super.addCommand(commands[i]);
            ++i;
        }
    }

    private void removeCommands(Command[] commands) {
        int i = commands.length;
        while (i-- > 0) {
            super.removeCommand(commands[i]);
        }
    }

    private static final class Destination
    extends WeakReference
    implements CharDestination {
        Destination(TextField thisItem) {
            super(thisItem);
        }

        public void insert(char src) {
            TextField thisItem = (TextField)this.get();
            if (thisItem == null) {
                return;
            }
            thisItem.insert(src);
        }

        public void insert(String src) {
            TextField thisItem = (TextField)this.get();
            if (thisItem == null) {
                return;
            }
            thisItem.insert(src);
        }
    }
}

