/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    protected OutputStream out;

    private static int writeUTF(DataOutput stream, String utfData) throws IOException {
        char ci;
        if (utfData == null) {
            throw new NullPointerException("DataOutputStream.writeUTF: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 utfData \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = 0;
        int strlen = utfData.length();
        char[] c = new char[strlen];
        utfData.getChars(0, strlen, c, 0);
        int i = strlen;
        while (i-- > 0) {
            ci = c[i];
            length += ci >= '\u0001' && ci < '\u0080' ? 1 : (ci < '\u0800' ? 2 : 3);
        }
        if (length >= 65536) {
            throw new UTFDataFormatException("DataOutputStream.writeUTF: \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 65535 \u0431\u0430\u0439\u0442.");
        }
        byte[] result = new byte[length];
        length = 0;
        i = 0;
        while (i < strlen) {
            ci = c[i];
            if (ci >= '\u0001' && ci < '\u0080') {
                result[length++] = (byte)ci;
            } else if (ci < '\u0800') {
                result[length++] = (byte)(0xC0 | ci >> 6 & 0x1F);
                result[length++] = (byte)(0x80 | ci & 0x3F);
            } else {
                result[length++] = (byte)(0xE0 | ci >> 12 & 0xF);
                result[length++] = (byte)(0x80 | ci >> 6 & 0x3F);
                result[length++] = (byte)(0x80 | ci & 0x3F);
            }
            ++i;
        }
        stream.writeShort(length);
        stream.write(result, 0, length);
        return length + 2;
    }

    public DataOutputStream(OutputStream stream) {
        this.out = stream;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int byteData) throws IOException {
        this.out.write(byteData);
    }

    public void write(byte[] src, int offset, int length) throws IOException {
        this.out.write(src, offset, length);
    }

    public final void writeBoolean(boolean booleanData) throws IOException {
        this.out.write(booleanData ? 1 : 0);
    }

    public final void writeChar(int charData) throws IOException {
        OutputStream stream = this.out;
        stream.write(charData >> 8);
        stream.write(charData);
    }

    public final void writeFloat(float floatData) throws IOException {
        this.writeInt(Float.floatToIntBits(floatData));
    }

    public final void writeDouble(double doubleData) throws IOException {
        this.writeLong(Double.doubleToLongBits(doubleData));
    }

    public final void writeByte(int byteData) throws IOException {
        this.out.write(byteData);
    }

    public final void writeShort(int shortData) throws IOException {
        OutputStream stream = this.out;
        stream.write(shortData >> 8);
        stream.write(shortData);
    }

    public final void writeInt(int intData) throws IOException {
        OutputStream stream = this.out;
        stream.write(intData >> 24);
        stream.write(intData >> 16);
        stream.write(intData >> 8);
        stream.write(intData);
    }

    public final void writeLong(long longData) throws IOException {
        OutputStream stream = this.out;
        stream.write((int)(longData >> 56));
        stream.write((int)(longData >> 48));
        stream.write((int)(longData >> 40));
        stream.write((int)(longData >> 32));
        stream.write((int)(longData >> 24));
        stream.write((int)(longData >> 16));
        stream.write((int)(longData >> 8));
        stream.write((int)longData);
    }

    public final void writeChars(String charsData) throws IOException {
        if (charsData == null) {
            throw new NullPointerException("DataOutputStream.writeChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 charsData \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        OutputStream stream = this.out;
        char[] c = charsData.toCharArray();
        int len = c.length;
        int i = 0;
        while (i < len) {
            char charData = c[i];
            stream.write(charData >> 8);
            stream.write(charData);
            ++i;
        }
    }

    public final void writeUTF(String utfData) throws IOException {
        DataOutputStream.writeUTF(this, utfData);
    }
}

