/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.StringBuilder;

public final class Long {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    private final long value;

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int radix) throws NumberFormatException {
        long digit;
        long limit;
        boolean negative;
        int len;
        if (string == null || (len = string.length()) <= 0) {
            throw new NumberFormatException("Long.parseLong: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
        }
        if (radix > 36) {
            throw new NumberFormatException(new StringBuilder().append("Long.parseLong: \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f (").append(radix).append(") \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c Character.MAX_RADIX.").toString());
        }
        if (radix < 2) {
            throw new NumberFormatException(new StringBuilder().append("Long.parseLong: \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f (").append(radix).append(") \u043c\u0435\u043d\u044c\u0448\u0435, \u0447\u0435\u043c Character.MIN_RADIX.").toString());
        }
        long result = 0L;
        int i = 0;
        if (string.charAt(0) == '-') {
            ++i;
            negative = true;
            limit = Long.MIN_VALUE;
        } else {
            negative = false;
            limit = -9223372036854775807L;
        }
        long mulmin = limit / (long)radix;
        if (i < len) {
            if ((digit = (long)Character.digit(string.charAt(i++), radix)) < 0L) {
                throw new NumberFormatException("Long.parseLong: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            result = -digit;
        }
        while (i < len) {
            if ((digit = (long)Character.digit(string.charAt(i++), radix)) < 0L || result < mulmin || (result *= (long)radix) < limit + digit) {
                throw new NumberFormatException("Long.parseLong: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            result -= digit;
        }
        if (negative) {
            if (i <= 1) {
                throw new NumberFormatException("Long.parseLong: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            return result;
        }
        return -result;
    }

    public static String toString(long value) {
        return Long.toString(value, 10);
    }

    public static String toString(long value, int radix) {
        boolean negative = value < 0L;
        int i = 64;
        int len = 64 + 1;
        char[] buf = new char[len];
        if (radix > 36 || radix < 2) {
            radix = 10;
        }
        if (!negative) {
            value = -value;
        }
        long posradix = radix;
        long negradix = -posradix;
        while (value <= negradix) {
            buf[i--] = Character.getDigitRepresentation((int)(-(value % posradix)));
            value /= posradix;
        }
        buf[i] = Character.getDigitRepresentation((int)(-value));
        if (negative) {
            buf[--i] = 45;
        }
        return new String(buf, i, len - i);
    }

    public Long(long value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Long && this.value == ((Long)anot).value;
    }

    public int hashCode() {
        long bits = this.value;
        return (int)(bits ^ bits >> 32);
    }

    public String toString() {
        return Long.toString(this.value, 10);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }
}

