/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import malik.emulator.fileformats.text.mapped.MappedTextDecoder;
import malik.emulator.fileformats.text.mapped.PropertiesDecoder;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.cloud.FileOutputStream;

public final class System {
    private static final MappedTextDecoder config;
    public static final PrintStream out;
    public static final PrintStream err;

    static {
        OutputStream stderr;
        OutputStream stdout;
        PropertiesDecoder cfg = new PropertiesDecoder();
        try {
            FileInputStream stream = new FileInputStream("/config.properties");
            try {
                cfg.loadFromInputStream(stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (IOException iOException) {}
        try {
            stdout = (OutputStream)Class.forName(cfg.get("malik.emulator.application.out.class")).newInstance();
        }
        catch (Exception exception) {
            stdout = new FileOutputStream("/out.txt");
        }
        try {
            stderr = (OutputStream)Class.forName(cfg.get("malik.emulator.application.err.class")).newInstance();
        }
        catch (Exception exception) {
            stderr = new FileOutputStream("/err.txt");
        }
        config = cfg;
        out = new PrintStream(stdout);
        err = new PrintStream(stderr);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void arraycopy(Object src, int srcOffset, Object dst, int dstOffset, int length) {
        if (src == null) {
            throw new NullPointerException("System.arraycopy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("System.arraycopy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Class srcComponentType = src.getClass().componentType;
        if (srcComponentType == null) {
            throw new ArrayStoreException("System.arraycopy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c.");
        }
        Class dstComponentType = dst.getClass().componentType;
        if (dstComponentType == null) {
            throw new ArrayStoreException("System.arraycopy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c.");
        }
        if (((srcComponentType.modifiers & 0x10000) != 0 || (dstComponentType.modifiers & 0x10000) != 0) && srcComponentType != dstComponentType) {
            throw new ArrayStoreException("System.arraycopy", dstComponentType, srcComponentType, false);
        }
        Class type = MalikSystem.getClassInstance("Z");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((boolean[])src, srcOffset, (boolean[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("C");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((char[])src, srcOffset, (char[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("F");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((float[])src, srcOffset, (float[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("D");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((double[])src, srcOffset, (double[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("B");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((byte[])src, srcOffset, (byte[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("S");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((short[])src, srcOffset, (short[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("I");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((int[])src, srcOffset, (int[])dst, dstOffset, length);
            return;
        }
        type = MalikSystem.getClassInstance("J");
        if (srcComponentType == type && dstComponentType == type) {
            Array.copy((long[])src, srcOffset, (long[])dst, dstOffset, length);
            return;
        }
        if (dstComponentType.isAssignableFrom(srcComponentType)) {
            Array.copy((Object[])src, srcOffset, (Object[])dst, dstOffset, length);
            return;
        }
        Array.copyReferences((Object[])src, srcOffset, (Object[])dst, dstOffset, length);
    }

    public static int identityHashCode(Object reference) {
        return MalikSystem.convertToReference(reference);
    }

    public static long currentTimeMillis() {
        return MalikSystem.syscall(2L, 12) - 62135596800000L;
    }

    public static String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("System.getSystemProperty: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key.length() <= 0) {
            throw new IllegalArgumentException("System.getSystemProperty: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        return System.readProperty(false, key);
    }

    public static String getSystemProperty(String key) {
        if (key == null) {
            throw new NullPointerException("System.getSystemProperty: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key.length() <= 0) {
            throw new IllegalArgumentException("System.getSystemProperty: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        return System.readProperty(true, key);
    }

    private static String readProperty(boolean fromSystem, String key) {
        return !fromSystem && key.startsWith("malik.emulator.") ? null : config.get(key);
    }

    private System() {
    }
}

