/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import malik.emulator.application.InputDevice;
import malik.emulator.application.InputEvent;

public class PointerEvent
extends InputEvent {
    public static final int BUTTON_MAIN = 0;
    public static final int BUTTON_AUX_1 = 1;
    public static final int BUTTON_AUX_2 = 2;
    public static final int BUTTON_AUX_3 = 3;
    public static final int BUTTON_AUX_4 = 4;
    public static final int BUTTON_AUX_5 = 5;
    public static final int BUTTON_AUX_6 = 6;
    public static final int BUTTON_AUX_7 = 7;
    public static final int BUTTON_AUX_8 = 8;
    public static final int BUTTON_AUX_9 = 9;
    public static final int BUTTON_AUX_10 = 10;
    public static final int BUTTON_AUX_11 = 11;
    public static final int BUTTON_AUX_12 = 12;
    public static final int BUTTON_WHEEL = 13;
    public static final int BUTTON_WHEEL_UP = 14;
    public static final int BUTTON_WHEEL_DOWN = 15;
    public static final int ACTION_POINTER_PRESSED = 10;
    public static final int ACTION_POINTER_DRAGGED = 9;
    public static final int ACTION_POINTER_RELEASED = 11;
    public static final int ACTION_BUTTON_PRESSED = 14;
    public static final int ACTION_BUTTON_RELEASED = 15;
    private static final int OFFSET_BUTTON = 1;
    private static final int OFFSET_COORDS = 2;
    private static final int OFFSET_SOURCE = 3;
    private static final int OFFSET_EVENT_TIME_LO = 4;
    private static final int OFFSET_EVENT_TIME_HI = 5;
    private static final int OFFSET_VIRTUAL_DATA_LO = 6;
    private static final int OFFSET_VIRTUAL_DATA_HI = 7;
    private static final int ELEMENTS_PER_STORY = 8;
    private int tx;
    private int ty;
    private int base;
    private int length;
    private final int[] history;

    public PointerEvent() {
        this(256);
    }

    public PointerEvent(int historyCapacity) {
        if (historyCapacity < 2) {
            historyCapacity = 2;
        }
        if (historyCapacity > 4096) {
            historyCapacity = 4096;
        }
        this.base = (historyCapacity <<= 3) - 8;
        this.length = 8;
        this.history = new int[historyCapacity];
    }

    public int getSource() {
        return this.history[this.base + 3];
    }

    public long getEventTime() {
        int b = this.base;
        int[] h = this.history;
        return (long)h[b + 4] & 0xFFFFFFFFL | (long)h[b + 5] << 32;
    }

    public long getVirtualData() {
        int b = this.base;
        int[] h = this.history;
        return (long)h[b + 6] & 0xFFFFFFFFL | (long)h[b + 7] << 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStory(int action, int button, int rawX, int rawY, InputDevice device, int source, long virtualData) {
        if (action == 14) {
            action = 10;
        }
        if (action == 15) {
            action = 11;
        }
        if (action != 9 && action != 10 && action != 11) {
            throw new IllegalArgumentException("KeyboardEvent.addStory: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 action \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int[] history = this.history;
        int[] nArray = this.history;
        synchronized (nArray) {
            int capacity = history.length;
            int oldBase = this.base;
            int newBase = this.base = (oldBase + capacity - 8) % capacity;
            int length = this.length;
            long time = System.currentTimeMillis();
            if (length < capacity) {
                this.length = length + 8;
            }
            history[newBase] = history[oldBase] & 0xFFFF0000;
            if (action == 9) {
                button = -1;
            } else if (button >= 0 && button <= 15) {
                int index = newBase;
                int bitbutton = 1 << button + 16;
                switch (action) {
                    case 10: {
                        int n = index;
                        history[n] = history[n] | bitbutton;
                        if ((history[n] & ~bitbutton) == 0) break;
                        action = 14;
                        break;
                    }
                    case 11: {
                        int n = index;
                        history[n] = history[n] & ~bitbutton;
                        if (history[n] == 0) break;
                        action = 15;
                    }
                }
            }
            this.device = device;
            history[newBase] = history[newBase] & 0xFFFF0000 | action;
            history[newBase + 1] = button;
            history[newBase + 2] = rawX & 0xFFFF | rawY << 16;
            history[newBase + 3] = source;
            history[newBase + 4] = (int)time;
            history[newBase + 5] = (int)(time >> 32);
            history[newBase + 6] = (int)virtualData;
            history[newBase + 7] = (int)(virtualData >> 32);
        }
    }

    public void translateReset() {
        this.tx = 0;
        this.ty = 0;
    }

    public void translate(int deltaX, int deltaY) {
        this.tx += deltaX;
        this.ty += deltaY;
    }

    public void translateTo(int rawX, int rawY) {
        this.tx = rawX;
        this.ty = rawY;
    }

    public boolean historicalFromSource(int storyIndex, int source) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalFromSource: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (h[b + 3] & source) == source;
    }

    public int historicalSource(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalSource: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return h[b + 3];
    }

    public int getTranslateX() {
        return this.tx;
    }

    public int getTranslateY() {
        return this.ty;
    }

    public long historicalEventTime(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalEventTime: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (long)h[b + 4] & 0xFFFFFFFFL | (long)h[b + 5] << 32;
    }

    public long historicalVirtualData(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalVirtualData: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (long)h[b + 6] & 0xFFFFFFFFL | (long)h[b + 7] << 32;
    }

    public final boolean isButtonPressed(int button) {
        return button >= 0 && button <= 15 && (this.history[this.base] & 1 << button + 16) != 0;
    }

    public final boolean historicalButtonPressed(int storyIndex, int button) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalButtonPressed: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return button >= 0 && button <= 15 && (h[b] & 1 << button + 16) != 0;
    }

    public final int historicalButton(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalButton: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return h[b + 1];
    }

    public final int historicalAction(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalAction: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return h[b] & 0xFFFF;
    }

    public final int historicalRawX(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalRawX: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (short)h[b + 2];
    }

    public final int historicalRawY(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalRawY: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return h[b + 2] >> 16;
    }

    public final int historicalX(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalX: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (short)h[b + 2] - this.tx;
    }

    public final int historicalY(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 3) {
            throw new IndexOutOfBoundsException("PointerEvent.historicalY: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 3)) % h.length;
        return (h[b + 2] >> 16) - this.ty;
    }

    public final int historyCapacity() {
        return this.history.length >> 3;
    }

    public final int historyLength() {
        return this.length >> 3;
    }

    public final int getButton() {
        return this.history[this.base + 1];
    }

    public final int getAction() {
        return this.history[this.base] & 0xFFFF;
    }

    public final int getRawX() {
        return (short)this.history[this.base + 2];
    }

    public final int getRawY() {
        return this.history[this.base + 2] >> 16;
    }

    public final int getX() {
        return (short)this.history[this.base + 2] - this.tx;
    }

    public final int getY() {
        return (this.history[this.base + 2] >> 16) - this.ty;
    }
}

