/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.RasterBufferDescriptor;
import malik.emulator.media.graphics.Rectangle;
import malik.emulator.media.graphics.StretchDrawDescriptor;

public final class PrimitiveRender {
    private int x;
    private int y;
    private final long address;
    private final RasterBufferDescriptor source;
    private final StretchDrawDescriptor descriptor;

    PrimitiveRender(RasterBufferDescriptor source, StretchDrawDescriptor descriptor) {
        this.address = descriptor.getDescriptorAddress();
        this.source = source;
        this.descriptor = descriptor;
    }

    public void drawPixel(int x, int y) {
        this.descriptor.assignStretch(this.source, 0, this.x + x, this.y + y, 1, 1);
        MalikSystem.syscall(this.address, 39);
    }

    public void drawHorizontalLine(int x, int y, int length) {
        if (length < 0) {
            length = -length;
            x -= length;
        }
        this.descriptor.assignStretch(this.source, 0, this.x + x, this.y + y, length, 1);
        MalikSystem.syscall(this.address, 39);
    }

    public void drawVerticalLine(int x, int y, int length) {
        if (length < 0) {
            length = -length;
            y -= length;
        }
        this.descriptor.assignStretch(this.source, 0, this.x + x, this.y + y, 1, length);
        MalikSystem.syscall(this.address, 39);
    }

    public void fillRectangle(int left, int top, int width, int height) {
        if (width < 0) {
            width = -width;
            left -= width;
        }
        if (height < 0) {
            height = -height;
            top -= height;
        }
        this.descriptor.assignStretch(this.source, 0, this.x + left, this.y + top, width, height);
        MalikSystem.syscall(this.address, 39);
    }

    public void fillRectangle(Rectangle region) {
        if (region == null) {
            return;
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width < 0) {
            width = -width;
            left -= width;
        }
        if (height < 0) {
            height = -height;
            top -= height;
        }
        this.descriptor.assignStretch(this.source, 0, this.x + left, this.y + top, width, height);
        MalikSystem.syscall(this.address, 39);
    }

    void setCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
    }
}

