/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.sound;

import malik.emulator.application.PCMPlayerListener;
import malik.emulator.application.Run;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.util.DataDescriptor;
import malik.emulator.util.StringBuilder;

public final class SampledSoundPlayer
extends SoundPlayer {
    public static final int MAX_CHANNELS = 256;
    public static final int MAX_SAMPLES_PER_SECOND = 48000;
    public static final int MAX_BLOCK_LENGTH = 65536;
    public static final int MIN_BLOCK_LENGTH = 256;
    int handle;
    private final DataDescriptor descriptor;

    public static SampledSoundPlayer open(int channels, int samplesPerSecond, int blockLength) throws SoundPlayerException {
        if (channels < 1 || channels > 256) {
            throw new IllegalArgumentException("SampledSoundPlayer.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 channels \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (samplesPerSecond < 1 || samplesPerSecond > 48000) {
            throw new IllegalArgumentException("SampledSoundPlayer.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 samplesPerSecond \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (blockLength < 256 || blockLength > 65536) {
            throw new IllegalArgumentException("SampledSoundPlayer.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 blockLength \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int handle = (int)MalikSystem.syscall(samplesPerSecond & 0xFFFF | 0x100000 | channels - 1 << 24, blockLength, 48);
        if (handle == 0) {
            throw new SoundPlayerException(new StringBuilder().append("SampledSoundPlayer.open: \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0442 \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u044c \u0418\u041a\u041c \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: ").append(samplesPerSecond).append(" \u0413\u0446, ").append(channels == 1 ? "\u043c\u043e\u043d\u043e." : (channels == 2 ? "\u0441\u0442\u0435\u0440\u0435\u043e." : Integer.toString(channels).concat(" \u043a\u0430\u043d\u0430\u043b\u043e\u0432."))).toString());
        }
        return new SampledSoundPlayer(handle);
    }

    private SampledSoundPlayer(int handle) {
        this.handle = handle;
        this.descriptor = new DataDescriptor();
        Run.instance.setPCMPlayerListener(handle, new PCMPlayerListener(){

            public void endOfBlock(int playerHandle, int blockIndexForLoad) {
                SoundPlayerListener listener;
                SampledSoundPlayer parent = SampledSoundPlayer.this;
                if (playerHandle == parent.handle && (listener = parent.listener) != null) {
                    listener.endOfBlock(parent, blockIndexForLoad);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h != 0) {
                this.handle = 0;
                this.listener = null;
                MalikSystem.syscall((long)h, 55);
                Run.instance.setPCMPlayerListener(h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBlock(long[] packedSamples, int offset, int length) throws SoundPlayerException {
        DataDescriptor d;
        if (packedSamples == null) {
            throw new NullPointerException("SampledSoundPlayer.loadBlock: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 packedSamples \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("SampledSoundPlayer.loadBlock", packedSamples.length, offset, length);
        if (length <= 0) {
            return 0;
        }
        boolean error = false;
        DataDescriptor dataDescriptor = d = this.descriptor;
        synchronized (d) {
            int result;
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                d.setDataInfo(Array.getFirstElementAddress(packedSamples) + (offset << 3), length);
                result = (int)MalikSystem.syscall(h, d.getDescriptorAddress(), 49);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (error) {
                throw new SoundPlayerException("SampledSoundPlayer.loadBlock: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 0, 50);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.reset: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 1, 50);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 2, 50);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.stop: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setVolume(int volume) throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, super.setVolume(volume), 54);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.setVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCurrentBlockPosition(int position) throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, position, 52);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.setCurrentBlockPosition: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall((long)h, 51);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.getState: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolume() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, -1, 54);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.getVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentBlockIndex() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)(MalikSystem.syscall(h, 0, 53) >> 32);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.getCurrentBlockIndex: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentBlockPosition() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 0, 53);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.getCurrentBlockPosition: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentBlockIndexAndPosition() throws SoundPlayerException {
        long result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0L;
            } else {
                result = MalikSystem.syscall(h, 0, 53);
            }
        }
        if (error) {
            throw new SoundPlayerException("SampledSoundPlayer.getCurrentBlockIndexAndPosition: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }
}

