/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import malik.emulator.io.jar.ResourceStream;
import malik.emulator.util.StringBuilder;

public final class Class {
    static final int PUBLIC = 1;
    static final int PRIVATE = 2;
    static final int PROTECTED = 4;
    static final int STATIC = 8;
    static final int FINAL = 16;
    static final int SYNCHRONIZED = 32;
    static final int VOLATILE = 64;
    static final int TRANSIENT = 128;
    static final int NATIVE = 256;
    static final int INTERFACE = 512;
    static final int ABSTRACT = 1024;
    static final int STRICTFP = 2048;
    static final int SYNTHETIC = 4096;
    static final int PRIMITIVE = 65536;
    final int modifiers;
    private final int instanceSize;
    private final int nameIndex;
    final int[] referenceOffsets;
    private final int[] virtualAddresses;
    private final long[] dynamicIndexesAndAddresses;
    private final InterfaceEntry[] interfaceEntries;
    final Class superType;
    final Class componentType;
    private Class nextType;
    Thread initializingThread;
    private String name;
    private String canonicalName;

    public static Class forName(String typeName) throws ClassNotFoundException {
        if (typeName == null) {
            throw new ClassNotFoundException("Class.forName: \u043a\u043b\u0430\u0441\u0441 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c-\u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u043e\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        int len = typeName.length();
        if (len <= 0) {
            throw new ClassNotFoundException("Class.forName: \u043a\u043b\u0430\u0441\u0441 \u0441 \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        boolean array = typeName.charAt(0) == '[';
        if (array && len == 2) {
            switch (typeName.charAt(1)) {
                default: {
                    break;
                }
                case 'Z': {
                    return MalikSystem.getClassInstance("[Z");
                }
                case 'C': {
                    return MalikSystem.getClassInstance("[C");
                }
                case 'F': {
                    return MalikSystem.getClassInstance("[F");
                }
                case 'D': {
                    return MalikSystem.getClassInstance("[D");
                }
                case 'B': {
                    return MalikSystem.getClassInstance("[B");
                }
                case 'S': {
                    return MalikSystem.getClassInstance("[S");
                }
                case 'I': {
                    return MalikSystem.getClassInstance("[I");
                }
                case 'J': {
                    return MalikSystem.getClassInstance("[J");
                }
            }
        }
        Class current = MalikSystem.getClassInstance("Ljava/lang/Object;");
        while (current != null) {
            if (typeName.equals(current.getName())) {
                return current;
            }
            current = current.nextType;
        }
        if (array) {
            int lim = len - 1;
            int dimc = 1;
            block23: while (dimc < 256 && dimc < len) {
                switch (typeName.charAt(dimc)) {
                    default: {
                        break block23;
                    }
                    case 'Z': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[Z"), dimc - 1);
                    }
                    case 'C': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[C"), dimc - 1);
                    }
                    case 'F': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[F"), dimc - 1);
                    }
                    case 'D': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[D"), dimc - 1);
                    }
                    case 'B': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[B"), dimc - 1);
                    }
                    case 'S': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[S"), dimc - 1);
                    }
                    case 'I': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[I"), dimc - 1);
                    }
                    case 'J': {
                        if (dimc != lim) break block23;
                        return Class.createArrayType(MalikSystem.getClassInstance("[J"), dimc - 1);
                    }
                    case 'L': {
                        if (typeName.charAt(lim) != ';' || lim - dimc <= 1 || typeName.charAt(dimc + 1) == '[') break block23;
                        return Class.createArrayType(Class.forName(typeName.substring(dimc + 1, lim)), dimc);
                    }
                    case '[': {
                        ++dimc;
                    }
                }
            }
        }
        throw new ClassNotFoundException(new StringBuilder().append("Class.forName: \u043a\u043b\u0430\u0441\u0441 ").append(typeName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString());
    }

    private static Class findArrayType(Class componentType, int dimensionsMaximum) {
        int dimensionsResult = componentType.getArrayDimensionsQuantity();
        Class result = componentType;
        if (dimensionsResult > 0) {
            dimensionsMaximum += dimensionsResult;
            componentType = componentType.getCellType();
        }
        Class current = MalikSystem.getClassInstance("[");
        while (current != null) {
            int dimensionsCurrent;
            if (current.getCellType() == componentType && (dimensionsCurrent = current.getArrayDimensionsQuantity()) > dimensionsResult && dimensionsCurrent <= dimensionsMaximum) {
                dimensionsResult = dimensionsCurrent;
                result = current;
            }
            current = current.nextType;
        }
        return result;
    }

    private static Class createArrayType(Class componentType, int dimensionsQuantity) {
        Class result;
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            result = Class.findArrayType(componentType, dimensionsQuantity);
            dimensionsQuantity -= result.getArrayDimensionsQuantity() - componentType.getArrayDimensionsQuantity();
            while (dimensionsQuantity-- > 0) {
                result = new Class(result);
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
        return result;
    }

    private Class(Class componentType) {
        Class firstArray = MalikSystem.getClassInstance("[");
        Class object = MalikSystem.getClassInstance("Ljava/lang/Object;");
        this.modifiers = 0x10 | componentType.modifiers & 7;
        this.instanceSize = 16;
        this.nameIndex = -1;
        this.referenceOffsets = object.referenceOffsets;
        int[] objectVirtuals = object.virtualAddresses;
        int len = object.virtualAddresses.length;
        int[] thisVirtuals = new int[len];
        this.virtualAddresses = thisVirtuals;
        this.dynamicIndexesAndAddresses = object.dynamicIndexesAndAddresses;
        this.interfaceEntries = new InterfaceEntry[0];
        this.superType = object;
        this.componentType = componentType;
        this.nextType = firstArray.nextType;
        this.name = (componentType.isArray() ? new StringBuilder().append('[').append(componentType.getName()) : new StringBuilder().append("[L").append(componentType.getName()).append(';')).toString();
        MalikSystem.arraycopyf_int(objectVirtuals, 1, thisVirtuals, 1, len - 1);
        firstArray.nextType = this;
    }

    public String toString() {
        return (this.modifiers & 0x10000) != 0 ? this.getName() : ((this.modifiers & 0x200) != 0 ? "interface " : "class ").concat(this.getName());
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isInstance(Object reference) {
        return reference != null && this.isAssignableFrom(reference.getClass());
    }

    public boolean isAssignableFrom(Class type) {
        if (type == null) {
            throw new NullPointerException("Class.isAssignableFrom: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (type == this) {
            return true;
        }
        int modifiers = type.modifiers;
        if ((modifiers & 0x10000) != 0) {
            return false;
        }
        if ((modifiers & 0x200) != 0 || type.componentType == null) {
            modifiers = this.modifiers;
            return (modifiers & 0x200) != 0 && type.isInterfaceImplements(this) || (modifiers & 0x10000) == 0 && type.isInheritedFrom(this);
        }
        int thisDimensions = this.getArrayDimensionsQuantity();
        if (thisDimensions <= 0) {
            return this == MalikSystem.getClassInstance("Ljava/lang/Object;");
        }
        int typeDimensions = type.getArrayDimensionsQuantity();
        if (typeDimensions == thisDimensions) {
            return this.getCellType().isAssignableFrom(type.getCellType());
        }
        if (thisDimensions < typeDimensions) {
            return this.getCellType() == MalikSystem.getClassInstance("Ljava/lang/Object;");
        }
        return false;
    }

    public String getName() {
        String result = this.name;
        if (result == null) {
            result = this.name = StringPool.getString(this.nameIndex);
        }
        return result;
    }

    public String getCanonicalName() {
        String result = this.canonicalName;
        if (result != null) {
            return result;
        }
        StringBuilder buffer = new StringBuilder();
        int len = buffer.append(this.getName()).length();
        if (len > 0 && buffer.get(0) == '[') {
            int dimc = 1;
            while (dimc < len && buffer.get(dimc) == '[') {
                ++dimc;
            }
            if (dimc < len) {
                buffer.delete(0, dimc);
                len -= dimc;
                switch (buffer.get(0)) {
                    default: {
                        break;
                    }
                    case 'Z': {
                        buffer.delete(0).append("boolean");
                        break;
                    }
                    case 'C': {
                        buffer.delete(0).append("char");
                        break;
                    }
                    case 'F': {
                        buffer.delete(0).append("float");
                        break;
                    }
                    case 'D': {
                        buffer.delete(0).append("delete");
                        break;
                    }
                    case 'B': {
                        buffer.delete(0).append("byte");
                        break;
                    }
                    case 'S': {
                        buffer.delete(0).append("short");
                        break;
                    }
                    case 'I': {
                        buffer.delete(0).append("int");
                        break;
                    }
                    case 'J': {
                        buffer.delete(0).append("long");
                        break;
                    }
                    case 'L': {
                        buffer.delete(0);
                        if (--len <= 0 || buffer.get(--len) != ';') break;
                        buffer.delete(len);
                    }
                }
                int i = dimc;
                while (i-- > 0) {
                    buffer.append("[]");
                }
            }
        }
        this.canonicalName = buffer.toString().replace('$', '.');
        return this.canonicalName;
    }

    public InputStream getResourceAsStream(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        if (resourceName.length() > 0 && resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        } else {
            String className = this.getName();
            int i = className.lastIndexOf(46);
            if (i >= 0) {
                resourceName = className.substring(0, i + 1).replace('.', '/').concat(resourceName);
            }
        }
        ResourceStream result = new ResourceStream("/res/".concat(resourceName), "/".concat(resourceName));
        return result.hasOpenError() ? null : result;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        Object result = this.allocateInstance(true);
        MalikSystem.invokeDefaultConstructor(result);
        return result;
    }

    boolean isInheritedFrom(Class type) {
        Class current = this.superType;
        while (current != null) {
            if (current == type) {
                return true;
            }
            current = current.superType;
        }
        return false;
    }

    boolean isInterfaceImplements(Class type) {
        Class current = this;
        do {
            InterfaceEntry[] entries = current.interfaceEntries;
            int i = current.interfaceEntries.length;
            while (i-- > 0) {
                if (entries[i].implementedInterface != type) continue;
                return true;
            }
        } while ((current = current.superType) != null);
        return false;
    }

    int getArrayDimensionsQuantity() {
        int result = 0;
        Class current = this.componentType;
        while (current != null) {
            ++result;
            current = current.componentType;
        }
        return result;
    }

    int getInterfaceMethodEntryPoint(Class type, int offset) {
        return this.getInterfaceEntry((Class)type).interfaceMethodTableAddress + offset;
    }

    Class getCellType() {
        Class result = this.componentType;
        if (result != null) {
            Class current;
            while ((current = result.componentType) != null) {
                result = current;
            }
        }
        return result;
    }

    Object cast(Object reference) {
        Class type;
        if (reference != null && !this.isAssignableFrom(type = reference.getClass())) {
            throw new ClassCastException(new StringBuilder().append("Class.cast: \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u0442\u0438\u043f\u0430 ").append(type.getCanonicalName()).append(" \u043a \u0442\u0438\u043f\u0443 ").append(this.getCanonicalName()).append('.').toString());
        }
        return reference;
    }

    Object allocateInstance() {
        Object result;
        try {
            result = this.allocateInstance(false);
        }
        catch (Exception e) {
            throw new InstantiationError(e.getMessage());
        }
        return result;
    }

    Object allocateInstance(boolean useDefaultConstructor) throws InstantiationException, IllegalAccessException {
        if (this.componentType != null) {
            throw new InstantiationException(new StringBuilder().append("Class.newInstance: \u0442\u0438\u043f ").append(this.getCanonicalName()).append(" \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c.").toString());
        }
        int modifiers = this.modifiers;
        if ((modifiers & 0x10600) != 0) {
            if ((modifiers & 0x600) != 0) {
                throw new InstantiationException(new StringBuilder().append("Class.newInstance: \u0442\u0438\u043f ").append(this.getCanonicalName()).append(" \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0430\u0431\u0441\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u043c.").toString());
            }
            if ((modifiers & 0x10000) != 0) {
                throw new InstantiationException(new StringBuilder().append("Class.newInstance: \u0442\u0438\u043f ").append(this.getCanonicalName()).append(" \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043d\u044b\u043c.").toString());
            }
        }
        if (useDefaultConstructor) {
            if ((modifiers & 1) == 0) {
                throw new IllegalAccessException(new StringBuilder().append("Class.newInstance: \u0442\u0438\u043f ").append(this.getCanonicalName()).append(" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u043c (public).").toString());
            }
            if (this.virtualAddresses[0] == 0) {
                throw new IllegalAccessException(new StringBuilder().append("Class.newInstance: \u043a\u043b\u0430\u0441\u0441 ").append(this.getCanonicalName()).append(" \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0433\u043e (public) \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430 \u0431\u0435\u0437 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432.").toString());
            }
        }
        return Memory.allocateInstanceOf(this, this.instanceSize, -1);
    }

    private InterfaceEntry getInterfaceEntry(Class type) {
        Class current = this;
        do {
            InterfaceEntry[] entries = current.interfaceEntries;
            int i = current.interfaceEntries.length;
            while (i-- > 0) {
                InterfaceEntry entry = entries[i];
                if (entry.implementedInterface != type) continue;
                return entry;
            }
        } while ((current = current.superType) != null);
        return null;
    }
}

