/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.RealValueRepresenter;

public final class Double {
    public static final double NaN = 0.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    private static final RealValueRepresenter representer = new RealValueRepresenter(15, 3);
    private final double value;

    public static boolean isNaN(double value) {
        return value != value;
    }

    public static boolean isInfinite(double value) {
        return value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return representer.parseDouble(string);
    }

    public static strictfp double longBitsToDouble(long bits) {
        return MalikSystem.getDoubleAt(MalikSystem.getLocalVariableAddress(bits));
    }

    public static strictfp long doubleToLongBits(double value) {
        return MalikSystem.getLongAt(MalikSystem.getLocalVariableAddress(value));
    }

    public static Double valueOf(String string) throws NumberFormatException {
        double value = representer.parseDouble(string);
        return new Double(value);
    }

    public static String toString(double value) {
        return representer.toString(value);
    }

    public Double(double value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)anot).value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >> 32);
    }

    public String toString() {
        return representer.toString(this.value);
    }

    public boolean isNaN() {
        double value = this.value;
        return value != value;
    }

    public boolean isInfinite() {
        double value = this.value;
        return value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }
}

