/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Scheduler {
    public static final int ACTION = 0;
    public static final int THREAD = 1;
    public static final int MONOPOLY = 2;
    private static int COUNT = 0;
    private static Task[] QUEUE = new Task[16];

    static {
        MalikInterrupt.register(24, new TimerInterruptHandler());
    }

    public static void schedule(Task task, long delay, int mode) {
        if (task == null) {
            throw new NullPointerException("Scheduler.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("Scheduler.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 delay \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Scheduler.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 mode.");
        }
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            if (Scheduler.indexOf(task) < 0) {
                task.periodic = false;
                task.mode = mode;
                task.runningTime = System.currentTimeMillis() + delay;
                Scheduler.push(task);
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
    }

    public static void schedule(Task task, long delay, long period, int mode) {
        if (task == null) {
            throw new NullPointerException("Scheduler.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("Scheduler.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 delay \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Scheduler.schedule: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 period \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Scheduler.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 mode.");
        }
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            if (Scheduler.indexOf(task) < 0) {
                task.periodic = true;
                task.mode = mode;
                task.period = period;
                task.runningTime = System.currentTimeMillis() + delay;
                Scheduler.push(task);
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
    }

    static void cancel(Task task) {
        try {
            boolean cancel = false;
            boolean status = MalikSystem.enterMonopolyAccess();
            try {
                int index = Scheduler.indexOf(task);
                if (index >= 0) {
                    if (index < COUNT - 1) {
                        MalikSystem.arraycopyf_object(QUEUE, index + 1, QUEUE, index, COUNT - index - 1);
                    }
                    Scheduler.QUEUE[--Scheduler.COUNT] = null;
                    Scheduler.updateTimer();
                    if (task.mode != 2) {
                        cancel = true;
                    } else {
                        task.cancelled();
                    }
                }
            }
            finally {
                MalikSystem.leaveMonopolyAccess(status);
            }
            if (cancel) {
                task.cancelled();
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    static void push(Task task) {
        if (COUNT == QUEUE.length) {
            Task[] taskArray = QUEUE;
            QUEUE = new Task[COUNT << 1];
            MalikSystem.arraycopyf_object(taskArray, 0, QUEUE, 0, COUNT);
        }
        int index = COUNT;
        long runningTime = task.runningTime;
        int i = 0;
        while (i < index) {
            if (Scheduler.QUEUE[i].runningTime <= runningTime) {
                index = i;
                MalikSystem.arraycopyb_object(QUEUE, COUNT, QUEUE, COUNT + 1, COUNT - index);
                break;
            }
            ++i;
        }
        ++COUNT;
        Scheduler.QUEUE[index] = task;
        Scheduler.updateTimer();
    }

    static Task pop() {
        if (COUNT == 0) {
            return null;
        }
        Task result = QUEUE[COUNT - 1];
        long remainingTime = result.runningTime - System.currentTimeMillis();
        if (remainingTime > 0L) {
            MalikSystem.syscall(remainingTime, 64);
            return null;
        }
        Scheduler.QUEUE[--Scheduler.COUNT] = null;
        Scheduler.updateTimer();
        return result;
    }

    private static void updateTimer() {
        if (COUNT > 0) {
            long remainingTime = Scheduler.QUEUE[Scheduler.COUNT - 1].runningTime - System.currentTimeMillis();
            if (remainingTime <= 0L) {
                remainingTime = 1L;
            }
            MalikSystem.syscall(remainingTime, 64);
            return;
        }
        MalikSystem.syscall(0L, 64);
    }

    private static int indexOf(Task task) {
        return COUNT > 0 ? MalikSystem.arrayfindb_object(QUEUE, COUNT - 1, task) : -1;
    }

    private Scheduler() {
    }

    public static abstract class Task
    implements Runnable {
        boolean periodic;
        int mode;
        long period;
        long runningTime;
        long scheduledTime = Long.MIN_VALUE;

        protected Task() {
        }

        public abstract void run();

        public void cancel() {
            Scheduler.cancel(this);
        }

        public final long scheduledTime() {
            return this.scheduledTime;
        }

        protected void cancelled() {
        }
    }
}

