/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimerTask;

final class TimerThread
extends Thread {
    private static final int STATE_MASK = 3;
    private static final int STATE_FREE = 0;
    private static final int STATE_SCHEDULED = 1;
    private static final int STATE_EXECUTING = 2;
    private static final int STATE_CANCELLED = 3;
    private static final int FLAG_PERIODIC = 4;
    private static final int FLAG_FIXED_RATE = 8;
    private static final Object MONITOR = new Object();
    private boolean terminated;
    private int length;
    private TimerTask[] queue = new TimerTask[8];
    private final Object monitor = new Object();

    public TimerThread() {
        super("\u041f\u043e\u0442\u043e\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0442\u0438\u043c\u0435\u0440\u0430");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object monitor = this.monitor;
        while (true) {
            boolean fixedRate;
            int flags;
            this.waitTask();
            if (this.terminated) break;
            TimerTask task = this.pop();
            if (task == null) continue;
            boolean mustContinue = false;
            Object object = monitor;
            synchronized (object) {
                flags = task.flags;
                boolean bl = fixedRate = (flags & 8) != 0;
                if ((flags & 3) != 1) {
                    task.flags = 3;
                    task.period = 0L;
                    task.nextExecutionTime = 0L;
                    task.shedExecutionTime = 0L;
                    task.owner = null;
                    mustContinue = true;
                } else {
                    task.flags = flags & 0xFFFFFFFC | 2;
                    task.shedExecutionTime = task.nextExecutionTime;
                    if (fixedRate) {
                        task.nextExecutionTime += task.period;
                    }
                }
            }
            if (mustContinue) continue;
            try {
                task.run();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            object = monitor;
            synchronized (object) {
                flags = task.flags;
                if ((flags & 3) != 2 || (flags & 4) == 0) {
                    task.flags = 3;
                    task.period = 0L;
                    task.nextExecutionTime = 0L;
                    task.shedExecutionTime = 0L;
                    task.owner = null;
                } else {
                    if (!fixedRate) {
                        task.nextExecutionTime = System.currentTimeMillis() + task.period;
                    }
                    task.flags = flags & 0xFFFFFFFC | 1;
                    this.push(task);
                }
            }
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object monitor;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            this.terminated = true;
            monitor.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TimerTask task, long time) {
        Object monitor;
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            if ((task.flags & 3) != 0) {
                error = true;
            } else {
                task.flags = 1;
                task.period = 0L;
            }
        }
        if (error) {
            throw new IllegalStateException("Timer.schedule: \u0437\u0430\u0434\u0430\u0447\u0430 \u0443\u0436\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0440\u0430\u043d\u043d\u0435\u0435.");
        }
        object = monitor = this.monitor;
        synchronized (monitor) {
            task.nextExecutionTime = time;
            task.owner = this;
            this.push(task);
            monitor.notify();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TimerTask task, long time, long period, boolean fixedRate) {
        Object monitor;
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            if ((task.flags & 3) != 0) {
                error = true;
            } else {
                task.flags = fixedRate ? 13 : 5;
                task.period = period >= 0L ? period : 0L;
            }
        }
        if (error) {
            throw new IllegalStateException(fixedRate ? "Timer.scheduleAtFixedRate: \u0437\u0430\u0434\u0430\u0447\u0430 \u0443\u0436\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0440\u0430\u043d\u043d\u0435\u0435." : "Timer.schedule: \u0437\u0430\u0434\u0430\u0447\u0430 \u0443\u0436\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0440\u0430\u043d\u043d\u0435\u0435.");
        }
        object = monitor = this.monitor;
        synchronized (monitor) {
            task.nextExecutionTime = time;
            task.owner = this;
            this.push(task);
            monitor.notify();
            // ** MonitorExit[var9_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(TimerTask task) {
        Object monitor;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            boolean result;
            if (task.owner != this) {
                result = false;
            } else {
                int flags = task.flags;
                result = (flags & 4) != 0 || (flags & 3) == 1;
                Object[] queue = this.queue;
                int length = this.length - 1;
                int index = Array.findb(this.queue, length, task);
                if (index < 0) {
                    task.flags = 3;
                    task.period = 0L;
                    task.nextExecutionTime = 0L;
                    task.shedExecutionTime = 0L;
                    task.owner = null;
                } else {
                    if (index < length) {
                        Array.copy(queue, index + 1, queue, index, length - index);
                    }
                    this.length = length;
                    queue[this.length] = null;
                    task.flags = 3;
                    task.period = 0L;
                    task.nextExecutionTime = 0L;
                    task.shedExecutionTime = 0L;
                    task.owner = null;
                    monitor.notify();
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.monitor;
        synchronized (object) {
            TimerTask[] queue = this.queue;
            int i = this.length;
            while (i-- > 0) {
                TimerTask task = queue[i];
                queue[i].flags = 3;
                task.period = 0L;
                task.nextExecutionTime = 0L;
                task.shedExecutionTime = 0L;
                task.owner = null;
                queue[i] = null;
            }
            this.length = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTask() {
        Object monitor;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            while (true) {
                int length = this.length;
                TimerTask[] queue = this.queue;
                try {
                    if (length <= 0) {
                        monitor.wait();
                        break;
                    }
                    long remainingTime = queue[length - 1].nextExecutionTime - System.currentTimeMillis();
                    if (remainingTime <= 0L) break;
                    monitor.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void push(TimerTask task) {
        int length = this.length;
        Object[] queue = this.queue;
        if (length == this.queue.length) {
            Object[] objectArray = queue;
            this.queue = new TimerTask[length << 1];
            queue = this.queue;
            Array.copy(objectArray, 0, this.queue, 0, length);
        }
        int index = length;
        long time = task.nextExecutionTime;
        int i = 0;
        while (i < length) {
            if (((TimerTask)queue[i]).nextExecutionTime <= time) {
                index = i;
                Array.copy(queue, index, queue, index + 1, length - index);
                break;
            }
            ++i;
        }
        queue[index] = task;
        this.length = length + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TimerTask pop() {
        Object object = this.monitor;
        synchronized (object) {
            int length = this.length - 1;
            if (length < 0) return null;
            TimerTask[] queue = this.queue;
            TimerTask result = this.queue[length];
            if (result.nextExecutionTime > System.currentTimeMillis()) return null;
            this.length = length;
            queue[this.length] = null;
            return result;
        }
    }
}

