/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.font;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import malik.emulator.fileformats.DataCodec;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.ExtendedDataOutputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.InvalidStreamException;
import malik.emulator.fileformats.font.CharacterCodeExistsException;
import malik.emulator.io.cloud.HandleInputStream;
import malik.emulator.io.cloud.HandleOutputStream;
import malik.emulator.util.StringBuilder;

public final class UnicodeRasterFont
implements DataCodec {
    static final int MAX_SIGNED_VALUE = 127;
    static final int MIN_SIGNED_VALUE = -128;
    static final int MAX_UNSIGNED_VALUE = 255;
    static final int MIN_UNSIGNED_VALUE = 0;
    public static final int MAX_COORDINATE = 127;
    public static final int MIN_COORDINATE = -127;
    public static final long SIGNATURE = 1430670932L;
    int count;
    long attributes;
    Glyph[] glyphs = new Glyph[15];
    String lastFileName;
    final Object monitor = new Object();

    static boolean isEmptyCol(int width, int height, byte[] pixels, int col) {
        int scan = UnicodeRasterFont.bytesNeeded(width);
        int mask = 1 << (col & 7);
        int i = col >> 3;
        int row = height;
        while (row-- > 0) {
            if ((pixels[i] & mask) != 0) {
                return false;
            }
            i += scan;
        }
        return true;
    }

    static boolean isEmptyRow(int width, int height, byte[] pixels, int row) {
        int scan = UnicodeRasterFont.bytesNeeded(width);
        int mend = UnicodeRasterFont.maskEnding(width);
        int base = scan * row;
        int c = scan + base - 1;
        int i = base;
        while (i <= c) {
            int mask;
            int n = mask = i < c ? 255 : mend;
            if ((pixels[i] & mask) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isEmptyGlyph(int width, int height, byte[] pixels) {
        int scan = UnicodeRasterFont.bytesNeeded(width);
        int mend = UnicodeRasterFont.maskEnding(width);
        int len = scan * height;
        int c = scan - 1;
        int i = 0;
        while (i < len) {
            int mask;
            if (i < c) {
                mask = 255;
            } else {
                mask = mend;
                c += scan;
            }
            if ((pixels[i] & mask) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean pixelsMatches(int width, int height, byte[] pixels1, byte[] pixels2) {
        int scan = UnicodeRasterFont.bytesNeeded(width);
        int mend = UnicodeRasterFont.maskEnding(width);
        int len = scan * height;
        int c = scan - 1;
        int i = 0;
        while (i < len) {
            int mask;
            if (i < c) {
                mask = 255;
            } else {
                mask = mend;
                c += scan;
            }
            if ((pixels1[i] & mask) != (pixels2[i] & mask)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static int pixelsHashCode(int width, int height, byte[] pixels) {
        int result = 0;
        int scan = UnicodeRasterFont.bytesNeeded(width);
        int mend = UnicodeRasterFont.maskEnding(width);
        int len = scan * height;
        int c = scan - 1;
        int i = 0;
        while (i < len) {
            int mask;
            if (i < c) {
                mask = 255;
            } else {
                mask = mend;
                c += scan;
            }
            result ^= (pixels[i] & mask) << (i << 3);
            ++i;
        }
        return result;
    }

    static int madeRectangle(int left, int bottom, int width, int height) {
        return left << 24 | (bottom & 0xFF) << 16 | (width & 0xFF) << 8 | height & 0xFF;
    }

    static int bytesNeeded(int width, int height) {
        return (width + (-width & 7) >> 3) * height;
    }

    static int bytesNeeded(int width) {
        return width + (-width & 7) >> 3;
    }

    static int toCanonical(int rectangle) {
        return (rectangle & 0xFF00) == 0 || (rectangle & 0xFF) == 0 ? 0 : rectangle;
    }

    static int maskEnding(int width) {
        return (width &= 7) > 0 ? (1 << width) - 1 : 255;
    }

    static int indexOf(int characterCode, Glyph[] glyphs, int count) {
        int limit1 = 0;
        int limit2 = count - 1;
        while (limit1 <= limit2) {
            int result = limit1 + limit2 >> 1;
            int guess = glyphs[result].getCharacterCode() - characterCode;
            if (guess < 0) {
                limit1 = result + 1;
                continue;
            }
            if (guess > 0) {
                limit2 = result - 1;
                continue;
            }
            return result;
        }
        return -1;
    }

    static int indexOf(Glyph glyph, Glyph[] glyphs, int count) {
        return Array.findb(glyphs, count - 1, glyph);
    }

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromDataStream(new ExtendedDataInputStream(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        if (!stream.markSupported()) {
            throw new InvalidStreamException("UnicodeRasterFont.loadFromDataStream: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434\u044b mark \u0438 reset.");
        }
        stream.mark(Integer.MAX_VALUE);
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len = this.count;
            Object[] g = this.glyphs;
            int i = len;
            while (i-- > 0) {
                g[i].removed = true;
            }
            this.count = 0;
            Array.fill(g, 0, len, null);
            this.attributes = stream.readLong();
            len = stream.readIntLE();
            if (len < 0) {
                error = true;
            } else {
                this.count = len;
                if (g.length < this.count) {
                    g = new Glyph[len + 15];
                    this.glyphs = g;
                }
                i = 0;
                while (i < len) {
                    stream.reset();
                    stream.skip(((long)i << 3) + 12L);
                    int characterCode = stream.readIntLE();
                    long position = (long)stream.readIntLE() & 0xFFFFFFFFL;
                    stream.reset();
                    stream.skip(position - 4L);
                    UnicodeRasterFont unicodeRasterFont = this;
                    unicodeRasterFont.getClass();
                    g[i] = unicodeRasterFont.new Glyph(false, characterCode, 0, 0, new byte[15]);
                    ((Glyph)g[i]).loadFromDataStream(stream);
                    ++i;
                }
                InputStream src = stream.getSourceStream();
                if (src instanceof HandleInputStream) {
                    this.lastFileName = ((HandleInputStream)src).getFileName();
                }
            }
        }
        if (error) {
            throw new InvalidDataFormatException("UnicodeRasterFont.loadFromDataStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 \u0448\u0440\u0438\u0444\u0442\u0430 UFN.");
        }
    }

    public void saveToOutputStream(OutputStream stream) throws IOException {
        this.saveToDataStream(new ExtendedDataOutputStream(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDataStream(ExtendedDataOutputStream stream) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            int offset;
            int len = this.count;
            int startoffset = offset = 16 + (len << 3);
            Glyph[] g = this.glyphs;
            int i = 0;
            while (i < len) {
                block10: {
                    Glyph curr = g[i];
                    int w = curr.getWidth();
                    int r = curr.rectangle;
                    int rw = r >> 8 & 0xFF;
                    int rh = r & 0xFF;
                    byte[] p = curr.pixels;
                    int j = 0;
                    while (j < i) {
                        Glyph jgl = g[j];
                        if (w == jgl.getWidth() && r == jgl.rectangle && UnicodeRasterFont.pixelsMatches(rw, rh, p, jgl.pixels)) {
                            curr.offset = jgl.offset;
                            break block10;
                        }
                        ++j;
                    }
                    curr.offset = offset;
                    offset += curr.getDataSize();
                }
                ++i;
            }
            offset = startoffset;
            stream.writeInt(1430670932);
            stream.writeLong(this.attributes);
            stream.writeIntLE(len);
            i = 0;
            while (i < len) {
                Glyph curr = g[i];
                stream.writeIntLE(curr.getCharacterCode());
                stream.writeIntLE(curr.offset);
                ++i;
            }
            i = 0;
            while (i < len) {
                Glyph curr = g[i];
                if (offset == curr.offset) {
                    curr.saveToDataStream(stream);
                    offset += curr.getDataSize();
                }
                ++i;
            }
            OutputStream dst = stream.getDestinationStream();
            if (dst instanceof HandleOutputStream) {
                this.lastFileName = ((HandleOutputStream)dst).getFileName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            int len = this.count;
            Object[] g = this.glyphs;
            int i = len;
            while (i-- > 0) {
                g[i].removed = true;
            }
            this.count = 0;
            Array.fill(g, 0, len, null);
            this.attributes = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean result;
        Object object = this.monitor;
        synchronized (object) {
            result = ((long)this.count | this.attributes) == 0L;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlyph(int characterCode) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] g = this.glyphs;
            int len = this.count;
            int index = UnicodeRasterFont.indexOf(characterCode, this.glyphs, len);
            if (index >= 0) {
                g[index].removed = true;
                if (index < --len) {
                    Array.copy(g, index + 1, g, index, len - index);
                }
                this.count = len;
                g[this.count] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlyph(Glyph character) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] g = this.glyphs;
            int len = this.count;
            int index = UnicodeRasterFont.indexOf(character, this.glyphs, len);
            if (index >= 0) {
                g[index].removed = true;
                if (index < --len) {
                    Array.copy(g, index + 1, g, index, len - index);
                }
                this.count = len;
                g[this.count] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBold(boolean bold) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = bold ? this.attributes | 0x100000000000000L : this.attributes & 0xFEFFFFFFFFFFFFFFL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItalic(boolean italic) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = italic ? this.attributes | 0x200000000000000L : this.attributes & 0xFDFFFFFFFFFFFFFFL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        if (height > 255) {
            height = 255;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFF00FFFFFFFFFFFFL | (long)height << 48;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaselineHeight(int baselineHeight) {
        if (baselineHeight < 0) {
            baselineHeight = 0;
        }
        if (baselineHeight > 255) {
            baselineHeight = 255;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFF00FFFFFFFFFFL | (long)baselineHeight << 40;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmallLettersHeight(int smallLettersHeight) {
        if (smallLettersHeight < 0) {
            smallLettersHeight = 0;
        }
        if (smallLettersHeight > 255) {
            smallLettersHeight = 255;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFFFF00FFFFFFFFL | (long)smallLettersHeight << 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapitalLettersHeight(int capitalLettersHeight) {
        if (capitalLettersHeight < 0) {
            capitalLettersHeight = 0;
        }
        if (capitalLettersHeight > 255) {
            capitalLettersHeight = 255;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFFFFFF00FFFFFFL | (long)capitalLettersHeight << 24;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrikeoutLinePosition(int strikeoutLinePosition) {
        if (strikeoutLinePosition < -128) {
            strikeoutLinePosition = -128;
        }
        if (strikeoutLinePosition > 127) {
            strikeoutLinePosition = 127;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFFFFFFFFFF00FFL | (long)(strikeoutLinePosition & 0xFF) << 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnderscoreLinePosition(int underscoreLinePosition) {
        if (underscoreLinePosition < -128) {
            underscoreLinePosition = -128;
        }
        if (underscoreLinePosition > 127) {
            underscoreLinePosition = 127;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFFFFFFFF00FFFFL | (long)(underscoreLinePosition & 0xFF) << 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesWidth(int linesWidth) {
        if (linesWidth < 0) {
            linesWidth = 0;
        }
        if (linesWidth > 255) {
            linesWidth = 255;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = this.attributes & 0xFFFFFFFFFFFFFF00L | (long)linesWidth;
        }
    }

    public boolean isBold() {
        return (this.attributes & 0x100000000000000L) != 0L;
    }

    public boolean isItalic() {
        return (this.attributes & 0x200000000000000L) != 0L;
    }

    public int getHeight() {
        return (int)(this.attributes >> 48) & 0xFF;
    }

    public int getBaselineHeight() {
        return (int)(this.attributes >> 40) & 0xFF;
    }

    public int getSmallLettersHeight() {
        return (int)(this.attributes >> 32) & 0xFF;
    }

    public int getCapitalLettersHeight() {
        return (int)(this.attributes >> 24) & 0xFF;
    }

    public int getStrikeoutLinePosition() {
        return (byte)(this.attributes >> 8);
    }

    public int getUnderscoreLinePosition() {
        return (byte)(this.attributes >> 16);
    }

    public int getLinesWidth() {
        int result = (int)this.attributes & 0xFF;
        return result == 0 ? 1 : result;
    }

    public int getGlyphsCount() {
        return this.count;
    }

    public String getLastFileName() {
        return this.lastFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyph getGlyph(int characterCode) {
        Glyph result;
        Object object = this.monitor;
        synchronized (object) {
            Glyph[] g = this.glyphs;
            int index = UnicodeRasterFont.indexOf(characterCode, this.glyphs, this.count);
            result = index >= 0 ? g[index] : null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyph addGlyph(int characterCode) {
        Glyph result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            block9: {
                Object[] g = this.glyphs;
                int len = this.count;
                if (UnicodeRasterFont.indexOf(characterCode, this.glyphs, len) >= 0) {
                    error = true;
                    result = null;
                } else {
                    if (len == g.length) {
                        Object[] objectArray = g;
                        this.glyphs = new Glyph[(len << 1) + 1];
                        g = this.glyphs;
                        Array.copy(objectArray, 0, this.glyphs, 0, len);
                    }
                    UnicodeRasterFont unicodeRasterFont = this;
                    unicodeRasterFont.getClass();
                    result = unicodeRasterFont.new Glyph(false, characterCode, 0, 0, new byte[15]);
                    int i = 0;
                    while (i < len) {
                        if (((Glyph)g[i]).getCharacterCode() > characterCode) {
                            Array.copy(g, i, g, i + 1, len++ - i);
                            g[i] = result;
                            this.count = len;
                            break block9;
                        }
                        ++i;
                    }
                    g[len++] = result;
                    this.count = len;
                }
            }
        }
        if (error) {
            throw new CharacterCodeExistsException(new StringBuilder().append("UnicodeRasterFont.addGlyph: \u0433\u043b\u0438\u0444 \u0441 \u043a\u043e\u0434\u043e\u043c ").append(characterCode).append(" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u044d\u0442\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435.").toString());
        }
        return result;
    }

    public Enumeration glyphs() {
        return new Enumerator();
    }

    private class Enumerator
    implements Enumeration {
        private int index;

        public boolean hasMoreElements() {
            return this.index < UnicodeRasterFont.this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Glyph result;
            boolean error = false;
            UnicodeRasterFont parent = UnicodeRasterFont.this;
            Object object = parent.monitor;
            synchronized (object) {
                int i = this.index;
                if (i >= parent.count) {
                    error = true;
                    result = null;
                } else {
                    result = parent.glyphs[i++];
                    this.index = i;
                }
            }
            if (error) {
                throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
            }
            return result;
        }
    }

    public class Glyph
    implements DataCodec {
        boolean removed;
        int characterCode;
        int offset;
        int width;
        int rectangle;
        byte[] pixels;

        Glyph(boolean removed, int characterCode, int width, int rectangle, byte[] pixels) {
            this.removed = removed;
            this.characterCode = characterCode;
            this.width = width;
            this.rectangle = rectangle;
            this.pixels = pixels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object anot) {
            boolean result;
            if (anot == this) {
                return true;
            }
            if (!(anot instanceof Glyph)) {
                return false;
            }
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                Glyph g = (Glyph)anot;
                Object object2 = g.monitor();
                synchronized (object2) {
                    int r;
                    result = this.width == g.width && (r = this.rectangle) == g.rectangle && UnicodeRasterFont.pixelsMatches(r >> 8 & 0xFF, r & 0xFF, this.pixels, g.pixels);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            int result;
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int r = this.rectangle;
                result = this.width << 12 ^ r ^ UnicodeRasterFont.pixelsHashCode(r >> 8 & 0xFF, r & 0xFF, this.pixels);
            }
            return result;
        }

        public void loadFromInputStream(InputStream stream) throws IOException {
            this.loadFromDataStream(new ExtendedDataInputStream(stream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int r;
                this.width = stream.readUnsignedByte();
                this.rectangle = r = UnicodeRasterFont.toCanonical(stream.readInt());
                stream.readFully(this.madeLarger(r), 0, UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF, r & 0xFF));
                if (r != 0) {
                    this.trim();
                }
            }
        }

        public void saveToOutputStream(OutputStream stream) throws IOException {
            this.saveToDataStream(new ExtendedDataOutputStream(stream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveToDataStream(ExtendedDataOutputStream stream) throws IOException {
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                stream.writeByte(this.width);
                int r = this.rectangle;
                stream.writeInt(r);
                stream.write(this.pixels, 0, UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF, r & 0xFF));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                this.width = 0;
                this.rectangle = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            boolean result;
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                result = (this.width | this.rectangle) == 0;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paste(Glyph source) {
            if (source == null) {
                throw new NullPointerException("Glyph.paste: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                Object object2 = source.monitor();
                synchronized (object2) {
                    int r;
                    this.width = source.width;
                    this.rectangle = r = source.rectangle;
                    Array.copy(source.pixels, 0, this.madeLarger(r), 0, UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF, r & 0xFF));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int deltaX, int deltaY) {
            if (deltaX == 0 && deltaY == 0) {
                return;
            }
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int r = this.rectangle;
                int maxX = 128 - (r >> 8 & 0xFF);
                int maxY = 128 - (r & 0xFF);
                int left = (r >> 24) + deltaX;
                int bottom = (byte)(r >> 16) + deltaY;
                if (left < -127) {
                    left = -127;
                }
                if (left > maxX) {
                    left = maxX;
                }
                if (bottom < -127) {
                    bottom = -127;
                }
                if (bottom > maxY) {
                    bottom = maxY;
                }
                this.rectangle = UnicodeRasterFont.toCanonical(r & 0xFFFF | left << 24 | (bottom & 0xFF) << 16);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putPixel(int x, int y, boolean opaque) {
            if (x < -127 || x > 127 || y < -127 || y > 127) {
                return;
            }
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int r = this.rectangle;
                int left = r >> 24;
                byte bottom = (byte)(r >> 16);
                int width = r >> 8 & 0xFF;
                int height = r & 0xFF;
                int right = left + width - 1;
                int top = bottom + height - 1;
                if (!opaque) {
                    if (x >= left && x <= right && y >= bottom && y <= top) {
                        int ax = x - left;
                        int ay = y - bottom;
                        int scan = UnicodeRasterFont.bytesNeeded(width);
                        int n = ay * scan + (ax >> 3);
                        this.pixels[n] = (byte)(this.pixels[n] & ~(1 << (ax & 7)));
                        if (x == left || x == right || y == bottom || y == top) {
                            this.trim();
                        }
                    }
                } else if ((r & 0xFFFF) == 0) {
                    this.rectangle = x << 24 | (y & 0xFF) << 16 | 0x101;
                    this.madeLarger((int)this.rectangle)[0] = 1;
                } else if (x >= left && x <= right && y >= bottom && y <= top) {
                    int ax = x - left;
                    int ay = y - bottom;
                    int scan = UnicodeRasterFont.bytesNeeded(width);
                    int n = ay * scan + (ax >> 3);
                    this.pixels[n] = (byte)(this.pixels[n] | 1 << (ax & 7));
                } else {
                    r = this.expand(x < left ? x - left : (x > right ? x - right : 0), y < bottom ? y - bottom : (y > top ? y - top : 0));
                    int ax = x - (r >> 24);
                    int ay = y - (byte)(r >> 16);
                    int scan = UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF);
                    int n = ay * scan + (ax >> 3);
                    this.pixels[n] = (byte)(this.pixels[n] | 1 << (ax & 7));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCharacterCode(int characterCode) {
            boolean error = false;
            UnicodeRasterFont parent = UnicodeRasterFont.this;
            Object object = parent.monitor;
            synchronized (object) {
                int oldCharacterCode = this.characterCode;
                if (characterCode != oldCharacterCode) {
                    if (this.removed) {
                        this.characterCode = characterCode;
                    } else {
                        Object[] glyphs = parent.glyphs;
                        int count = parent.getGlyphsCount();
                        if (UnicodeRasterFont.indexOf(characterCode, parent.glyphs, count) >= 0) {
                            error = true;
                        } else {
                            int newIndex = count;
                            int oldIndex = UnicodeRasterFont.indexOf(oldCharacterCode, (Glyph[])glyphs, count);
                            int i = 0;
                            while (i < count) {
                                if (glyphs[i].characterCode > characterCode) {
                                    newIndex = i;
                                    break;
                                }
                                ++i;
                            }
                            if (newIndex < oldIndex) {
                                Array.copy(glyphs, newIndex, glyphs, newIndex + 1, oldIndex - newIndex);
                            } else if (newIndex > oldIndex && --newIndex > oldIndex) {
                                Array.copy(glyphs, oldIndex + 1, glyphs, oldIndex, newIndex - oldIndex);
                            }
                            glyphs[newIndex] = this;
                            this.characterCode = characterCode;
                        }
                    }
                }
            }
            if (error) {
                throw new CharacterCodeExistsException(new StringBuilder().append("Glyph.setCharacterCode: \u0433\u043b\u0438\u0444 \u0441 \u043a\u043e\u0434\u043e\u043c ").append(characterCode).append(" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435.").toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWidth(int width) {
            if (width < 0) {
                width = 0;
            }
            if (width > 255) {
                width = 255;
            }
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                this.width = width;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getPixels(int[] pixels, int offset, int scanlength, int pixel) {
            if (pixels == null) {
                throw new NullPointerException("Glyph.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
            int error = 0;
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int r = this.rectangle;
                int width = r >> 8 & 0xFF;
                int height = r & 0xFF;
                if (scanlength > -width && scanlength < width) {
                    error = 1;
                } else {
                    int pixelsLength;
                    int pixelsOffset;
                    if (scanlength >= 0) {
                        pixelsOffset = offset;
                        pixelsLength = width + (height - 1) * scanlength;
                    } else {
                        pixelsOffset = offset + (height - 1) * scanlength;
                        pixelsLength = width + offset - pixelsOffset;
                    }
                    if (!Array.isBoundValid(pixels.length, pixelsOffset, pixelsLength)) {
                        error = 2;
                    } else {
                        byte[] p = this.pixels;
                        int scan = UnicodeRasterFont.bytesNeeded(width);
                        int step = -scanlength - width;
                        int offs = offset + scanlength * (height - 1);
                        int y = 0;
                        while (y < height) {
                            int x = 0;
                            while (x < width) {
                                if ((p[y * scan + (x >> 3)] & 1 << (x & 7)) != 0) {
                                    pixels[offs] = pixel;
                                }
                                ++offs;
                                ++x;
                            }
                            offs += step;
                            ++y;
                        }
                    }
                }
            }
            switch (error) {
                case 1: {
                    throw new IllegalArgumentException("Glyph.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 scanlength \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
                case 2: {
                    throw new ArrayIndexOutOfBoundsException("Glyph.getPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getPixel(int x, int y) {
            boolean result;
            Object object = UnicodeRasterFont.this.monitor;
            synchronized (object) {
                int scan;
                int r = this.rectangle;
                int left = r >> 24;
                byte bottom = (byte)(r >> 16);
                int width = r >> 8 & 0xFF;
                int right = left + width;
                int top = bottom + (r & 0xFF);
                result = x < left || x >= right || y < bottom || y >= top ? false : (this.pixels[(y -= bottom) * (scan = UnicodeRasterFont.bytesNeeded(width)) + ((x -= left) >> 3)] & 1 << (x & 7)) != 0;
            }
            return result;
        }

        public int getCharacterCode() {
            return this.characterCode;
        }

        public int getWidth() {
            return this.width;
        }

        public int getRawLeft() {
            return this.rectangle >> 24;
        }

        public int getRawBottom() {
            return (byte)(this.rectangle >> 16);
        }

        public int getRawWidth() {
            return this.rectangle >> 8 & 0xFF;
        }

        public int getRawHeight() {
            return this.rectangle & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Glyph copy() {
            byte[] p;
            int w;
            int c;
            int r;
            UnicodeRasterFont parent = UnicodeRasterFont.this;
            Object object = parent.monitor;
            synchronized (object) {
                r = this.rectangle;
                int len = UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF, r & 0xFF);
                c = this.characterCode;
                w = this.width;
                p = new byte[len < 15 ? 15 : len + 1];
                Array.copy(this.pixels, 0, p, 0, len);
            }
            UnicodeRasterFont unicodeRasterFont = parent;
            unicodeRasterFont.getClass();
            return unicodeRasterFont.new Glyph(true, c, w, r, p);
        }

        public UnicodeRasterFont parentFont() {
            return this.removed ? null : UnicodeRasterFont.this;
        }

        final void trim() {
            int row;
            int newIndex;
            int index;
            int newScan;
            int newWidth;
            int r = this.rectangle;
            int left = r >> 24;
            int bottom = r >> 16;
            int width = r >> 8 & 0xFF;
            int height = r & 0xFF;
            int scan = UnicodeRasterFont.bytesNeeded(width);
            byte[] pixels = this.pixels;
            if (UnicodeRasterFont.isEmptyGlyph(width, height, pixels)) {
                this.rectangle = 0;
                return;
            }
            int count = 0;
            int row2 = height;
            while (row2-- > 0) {
                if (!UnicodeRasterFont.isEmptyRow(width, height, pixels, row2)) break;
                ++count;
            }
            height -= count;
            count = 0;
            row2 = 0;
            while (row2 < height) {
                if (!UnicodeRasterFont.isEmptyRow(width, height, pixels, row2)) break;
                ++count;
                ++row2;
            }
            if (count > 0) {
                bottom += count;
                Array.copy(pixels, count * scan, pixels, 0, (height -= count) * scan);
            }
            count = 0;
            int col = width;
            while (col-- > 0) {
                if (!UnicodeRasterFont.isEmptyCol(width, height, pixels, col)) break;
                ++count;
            }
            if (count > 0) {
                newWidth = width - count;
                newScan = UnicodeRasterFont.bytesNeeded(newWidth);
                if (scan > newScan) {
                    index = scan;
                    newIndex = newScan;
                    row = height;
                    while (row-- > 1) {
                        Array.copy(pixels, index, pixels, newIndex, newScan);
                        index += scan;
                        newIndex += newScan;
                    }
                }
                width = newWidth;
                scan = newScan;
            }
            count = 0;
            col = 0;
            while (col < width) {
                if (!UnicodeRasterFont.isEmptyCol(width, height, pixels, col)) break;
                ++count;
                ++col;
            }
            if (count > 0) {
                newWidth = width - count;
                newScan = UnicodeRasterFont.bytesNeeded(newWidth);
                if ((count & 7) > 0) {
                    int ofs0 = count >> 3;
                    int ofs1 = 1 + ofs0;
                    int bits1 = count & 7;
                    int bits0 = 8 - bits1;
                    int mask1 = (1 << bits1) - 1;
                    int mask0 = 255 - mask1;
                    int mend = UnicodeRasterFont.maskEnding(newWidth);
                    int c = newScan - 1;
                    int f0 = ofs0;
                    int f1 = ofs1;
                    int to = 0;
                    int row3 = height;
                    while (row3-- > 0) {
                        int i = 0;
                        while (i <= c) {
                            int mask = i < c ? 255 : mend;
                            pixels[to + i] = (byte)(((pixels[f0 + i] & mask0) >> bits1 | (pixels[f1 + i] & mask1) << bits0) & mask);
                            ++i;
                        }
                        f0 += scan;
                        f1 += scan;
                        to += scan;
                    }
                } else {
                    int delta = count >> 3;
                    Array.copy(pixels, delta, pixels, 0, scan * height - delta);
                }
                if (scan > newScan) {
                    index = scan;
                    newIndex = newScan;
                    row = height;
                    while (row-- > 1) {
                        Array.copy(pixels, index, pixels, newIndex, newScan);
                        index += scan;
                        newIndex += newScan;
                    }
                }
                left += count;
                width = newWidth;
            }
            this.rectangle = UnicodeRasterFont.madeRectangle(left, bottom, width, height);
        }

        final int expand(int expandX, int expandY) {
            int row;
            int newIndex;
            int index;
            int newScan;
            int newWidth;
            int count;
            int r = this.rectangle;
            int left = r >> 24;
            int bottom = r >> 16;
            int width = r >> 8 & 0xFF;
            int height = r & 0xFF;
            int scan = UnicodeRasterFont.bytesNeeded(width);
            byte[] pixels = this.madeLarger(width + (expandX >= 0 ? expandX : -expandX), height + (expandY >= 0 ? expandY : -expandY));
            if (expandX < 0) {
                count = -expandX;
                newWidth = width + count;
                newScan = UnicodeRasterFont.bytesNeeded(newWidth);
                if (scan < newScan) {
                    index = scan * (height - 1);
                    newIndex = newScan * (height - 1);
                    row = height;
                    while (row-- > 1) {
                        Array.copy(pixels, index, pixels, newIndex, scan);
                        index -= scan;
                        newIndex -= newScan;
                    }
                }
                if ((count & 7) > 0) {
                    int len = count >> 3;
                    int bits0 = count & 7;
                    int bits1 = 8 - bits0;
                    int mask1 = (1 << bits1) - 1;
                    int mask0 = 255 - mask1;
                    int mend = UnicodeRasterFont.maskEnding(newWidth);
                    int c = newScan - len - 2;
                    int f0 = 0;
                    int f1 = 1;
                    int to = len + 1;
                    int row2 = height;
                    while (row2-- > 0) {
                        int mask;
                        int i = c;
                        while (i >= 0) {
                            mask = i < c ? 255 : mend;
                            pixels[to + i] = (byte)(((pixels[f0 + i] & mask0) >> bits1 | (pixels[f1 + i] & mask1) << bits0) & mask);
                            --i;
                        }
                        mask = -1 < c ? 255 : mend;
                        pixels[to - 1] = (byte)((pixels[f0] & mask1) << bits0 & mask);
                        Array.fill(pixels, f0, len, 0);
                        f0 += newScan;
                        f1 += newScan;
                        to += newScan;
                    }
                } else {
                    int delta = count >> 3;
                    Array.copy(pixels, 0, pixels, delta, newScan * height - delta);
                    int index2 = 0;
                    row = height;
                    while (row-- > 0) {
                        Array.fill(pixels, index2, delta, 0);
                        index2 += newScan;
                    }
                }
                left += expandX;
                width = newWidth;
                scan = newScan;
            }
            if (expandX > 0) {
                newWidth = width + expandX;
                newScan = UnicodeRasterFont.bytesNeeded(newWidth);
                if (scan < newScan) {
                    index = scan * (height - 1);
                    newIndex = newScan * (height - 1);
                    row = height;
                    while (row-- > 1) {
                        Array.copy(pixels, index, pixels, newIndex, scan);
                        index -= scan;
                        newIndex -= newScan;
                    }
                }
                int mend = UnicodeRasterFont.maskEnding(width);
                int c = scan - 1;
                int index3 = scan;
                int len = newScan - scan;
                int row3 = height;
                while (row3-- > 0) {
                    int n = c;
                    pixels[n] = (byte)(pixels[n] & mend);
                    Array.fill(pixels, index3, len, 0);
                    c += newScan;
                    index3 += newScan;
                }
                width = newWidth;
                scan = newScan;
            }
            if (expandY < 0) {
                count = -expandY * scan;
                Array.copy(pixels, 0, pixels, count, height * scan);
                Array.fill(pixels, 0, count, 0);
                bottom += expandY;
                height -= expandY;
            }
            if (expandY > 0) {
                Array.fill(pixels, height * scan, expandY * scan, 0);
                height += expandY;
            }
            this.rectangle = UnicodeRasterFont.madeRectangle(left, bottom, width, height);
            return this.rectangle;
        }

        final int getDataSize() {
            int r = this.rectangle;
            return UnicodeRasterFont.bytesNeeded(r >> 8 & 0xFF, r & 0xFF) + 5;
        }

        final byte[] madeLarger(int rectangle) {
            byte[] result;
            int len;
            int length = UnicodeRasterFont.bytesNeeded(rectangle >> 8 & 0xFF, rectangle & 0xFF) + 1;
            if (length > (len = (result = this.pixels).length)) {
                int newLength = (len << 1) + 1;
                int resLength = length >= newLength ? length : newLength;
                byte[] byArray = result;
                result = this.pixels = new byte[resLength];
                Array.copy(byArray, 0, this.pixels, 0, len);
            }
            return result;
        }

        final byte[] madeLarger(int width, int height) {
            byte[] result;
            int len;
            int length = UnicodeRasterFont.bytesNeeded(width, height) + 1;
            if (length > (len = (result = this.pixels).length)) {
                int newLength = (len << 1) + 1;
                int resLength = length >= newLength ? length : newLength;
                byte[] byArray = result;
                result = this.pixels = new byte[resLength];
                Array.copy(byArray, 0, this.pixels, 0, len);
            }
            return result;
        }

        final Object monitor() {
            return UnicodeRasterFont.this.monitor;
        }
    }
}

