/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileInfoDescriptor;
import malik.emulator.io.vfs.ClosedEnumerationException;
import malik.emulator.io.vfs.FileEnumeration;

final class CloudFileEnumeration
extends FileEnumeration {
    private int handle;
    private final char[] objectName;
    private final FileInfoDescriptor descriptor;

    public CloudFileEnumeration(int handle, char[] objectName, FileInfoDescriptor descriptor) {
        this.handle = handle;
        this.objectName = objectName;
        this.descriptor = descriptor;
        this.setAttributes(objectName, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileInfoDescriptor fileInfoDescriptor = this.descriptor;
        synchronized (fileInfoDescriptor) {
            this.closeHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findNext() throws IOException {
        FileInfoDescriptor d;
        boolean error = false;
        FileInfoDescriptor fileInfoDescriptor = d = this.descriptor;
        synchronized (d) {
            boolean result;
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = false;
            } else if (MalikSystem.syscall(h, d.getDescriptorAddress(), 25) != 1L) {
                result = false;
            } else {
                this.setAttributes(this.objectName, d);
                result = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (error) {
                throw new ClosedEnumerationException("FileEnumeration.findNext: \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
            }
            return result;
        }
    }

    protected void $finalize$() {
        this.closeHandle();
    }

    private void closeHandle() {
        int h = this.handle;
        if (h != 0) {
            MalikSystem.syscall((long)h, 26);
            this.handle = 0;
        }
    }

    private void setAttributes(char[] f, FileInfoDescriptor d) {
        this.setAttributes(d.attributes, CloudFileSystem.computeTime(d.timeOfCreation), CloudFileSystem.computeTime(d.timeOfLastWrite), CloudFileSystem.computeTime(d.timeOfLastAccess), d.size, new String(f, 0, Array.findf(f, 0, 0)));
    }
}

