/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.Clip;

public class Paint
extends Clip {
    private boolean alpha;
    private int color;

    public Paint(int clipWidth, int clipHeight) {
        super(clipWidth, clipHeight);
    }

    public Paint(int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public Paint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
    }

    public Paint(int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public Paint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
    }

    public Paint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }

    public void setColor(int colorARGB) {
        this.color = colorARGB;
    }

    public void setColor(int colorARGB, boolean alpha) {
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public void setColorRGB(int red, int green, int blue) {
        this.alpha = false;
        this.color = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public void setColorARGB(int red, int green, int blue, int alpha) {
        this.alpha = true;
        this.color = alpha << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public final boolean hasAlpha() {
        return this.alpha;
    }

    public final int getColor() {
        return this.color;
    }

    public final int getAlphaComponent() {
        return this.color >>> 24;
    }

    public final int getRedComponent() {
        return this.color >> 16 & 0xFF;
    }

    public final int getGreenComponent() {
        return this.color >> 8 & 0xFF;
    }

    public final int getBlueComponent() {
        return this.color & 0xFF;
    }
}

