/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.Clip;
import malik.emulator.media.graphics.Drawable;
import malik.emulator.media.graphics.GUIElementDescriptor;
import malik.emulator.media.graphics.Paint;
import malik.emulator.media.graphics.PrimitiveRender;
import malik.emulator.media.graphics.RasterBuffer;
import malik.emulator.media.graphics.RasterBufferDescriptor;
import malik.emulator.media.graphics.Rectangle;
import malik.emulator.media.graphics.StretchDrawDescriptor;
import malik.emulator.media.graphics.StringDrawDescriptor;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.media.graphics.TextPaint;
import malik.emulator.media.graphics.UninstalledFontException;

public class RasterCanvas {
    private static final int OPAQUE = 1;
    private static final int SCREEN = 2;
    public static final int MIN_SCREEN_WIDTH = 96;
    public static final int MIN_SCREEN_HEIGHT = 128;
    public static final int MAX_SCREEN_WIDTH = 1024;
    public static final int MAX_SCREEN_HEIGHT = 768;
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANSFORM_ROTATE_90 = 1;
    public static final int TRANSFORM_ROTATE_180 = 2;
    public static final int TRANSFORM_ROTATE_270 = 3;
    public static final int TRANSFORM_MIRROR = 4;
    public static final int TRANSFORM_MIRROR_ROTATE_90 = 5;
    public static final int TRANSFORM_MIRROR_ROTATE_180 = 6;
    public static final int TRANSFORM_MIRROR_ROTATE_270 = 7;
    public static final RasterCanvas screen;
    private boolean sizeChanged;
    private final int flags;
    private int width;
    private int height;
    private PrimitiveRender drawableRender;
    private StringDrawDescriptor stringDescriptor;
    private GUIElementDescriptor elementDescriptor;
    private StretchDrawDescriptor stretchDescriptor;
    private RasterBufferDescriptor rasterDescriptor;
    protected final RasterBuffer buffer;
    protected final Object monitor;

    static {
        RasterBufferDescriptor dst = new RasterBufferDescriptor();
        MalikSystem.syscall((long)dst.getDescriptorAddress() << 32, 34);
        int scan = dst.scan;
        int size = dst.size;
        int width = size & 0xFFFF;
        int height = size >>> 16;
        RasterBuffer buffer = RasterBuffer.create(Array.createSystemIntArray(dst.base, scan * 768), 0, scan, scan, 768, true);
        screen = new RasterCanvas(buffer, width, height, true);
    }

    public static int getGUIElementSize(int type, int subtype, int state) {
        return (int)MalikSystem.syscall((long)((state & 0xFF) << 16 | (subtype & 0xFF) << 8 | type & 0xFF), 36);
    }

    public static int getSystemColor(int index) {
        return (int)MalikSystem.syscall((long)index, 38);
    }

    public RasterCanvas(RasterBuffer buffer) {
        this(buffer, buffer != null ? buffer.getWidth() : 0, buffer != null ? buffer.getHeight() : 0, false);
    }

    public RasterCanvas(RasterBuffer buffer, int width, int height) {
        this(buffer, width, height, false);
    }

    private RasterCanvas(RasterBuffer buffer, int width, int height, boolean screen) {
        if (buffer == null) {
            throw new NullPointerException("RasterCanvas: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 buffer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 1 || width > buffer.getWidth()) {
            throw new IllegalArgumentException("RasterCanvas: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 1 || height > buffer.getHeight()) {
            throw new IllegalArgumentException("RasterCanvas: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.flags = (screen ? 2 : 0) | (buffer.isOpaque() ? 1 : 0);
        this.width = width;
        this.height = height;
        this.buffer = buffer;
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, int srcLeft, int srcTop, int srcWidth, int srcHeight, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, int srcLeft, int srcTop, int srcWidth, int srcHeight, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, Rectangle srcRegion, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (srcRegion == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 srcRegion \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLeft = srcRegion.getLeft();
        int srcTop = srcRegion.getTop();
        int srcWidth = srcRegion.getWidth();
        int srcHeight = srcRegion.getHeight();
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPixels(RasterBuffer src, Rectangle srcRegion, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (srcRegion == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 srcRegion \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLeft = srcRegion.getLeft();
        int srcTop = srcRegion.getTop();
        int srcWidth = srcRegion.getWidth();
        int srcHeight = srcRegion.getHeight();
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.copyPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int bottom;
            int right;
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && (right = left + width) > clipLeft && top < clipBottom && (bottom = top + height) > clipTop) {
                int areaLeft = clipLeft;
                int areaTop = clipTop;
                int areaRight = clipRight;
                int areaBottom = clipBottom;
                RasterBuffer thisBuffer = this.buffer;
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                if (areaLeft < left) {
                    areaLeft = left;
                }
                if (areaTop < top) {
                    areaTop = top;
                }
                if (areaRight > right) {
                    areaRight = right;
                }
                if (areaBottom > bottom) {
                    areaBottom = bottom;
                }
                int[] thisPixels = thisBuffer.getPixels();
                int step = thisBuffer.getScanlength();
                int length = areaRight - areaLeft;
                int offset = thisBuffer.getOffset() + areaLeft + areaTop * step;
                int i = areaTop;
                while (i < areaBottom) {
                    Array.fill(thisPixels, offset, length, 0);
                    offset += step;
                    ++i;
                }
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(thisBuffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                dstDescriptor.assignAlpha(true);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, 0, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, int srcLeft, int srcTop, int srcWidth, int srcHeight, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, int srcLeft, int srcTop, int srcWidth, int srcHeight, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, 0, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, Rectangle srcRegion, int transform, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (srcRegion == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 srcRegion \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLeft = srcRegion.getLeft();
        int srcTop = srcRegion.getTop();
        int srcWidth = srcRegion.getWidth();
        int srcHeight = srcRegion.getHeight();
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, transform, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixels(RasterBuffer src, Rectangle srcRegion, int transform, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (srcRegion == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 srcRegion \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLeft = srcRegion.getLeft();
        int srcTop = srcRegion.getTop();
        int srcWidth = srcRegion.getWidth();
        int srcHeight = srcRegion.getHeight();
        int lim = srcLeft + srcWidth;
        int size = src.getWidth();
        if (lim > size || lim < srcLeft || srcLeft > size || srcLeft < 0 || (lim = srcTop + srcHeight) > (size = src.getHeight()) || lim < srcTop || srcTop > size || srcTop < 0) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.drawPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor srcDescriptor = this.getRasterDescriptor();
                StretchDrawDescriptor dstDescriptor = this.getStretchDescriptor();
                srcDescriptor.assignBuffer(src, srcLeft, srcTop, srcWidth, srcHeight);
                dstDescriptor.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dstDescriptor.assignStretch(srcDescriptor, 0, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dstDescriptor.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGUIElement(int type, int subtype, int state, int left, int top, int width, int height, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawGUIElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                GUIElementDescriptor dst = this.getElementDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignGUIElement(type, subtype, state, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 37);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGUIElement(int type, int subtype, int state, Rectangle region, Clip clip) {
        if (clip == null) {
            throw new NullPointerException("RasterCanvas.drawGUIElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.drawGUIElement: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        left += clip.getTranslateX();
        top += clip.getTranslateY();
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipRight = clipLeft + clip.getWidth();
        int clipBottom = clipTop + clip.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                GUIElementDescriptor dst = this.getElementDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignGUIElement(type, subtype, state, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 37);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacter(int charCode, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCharacter: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(false, MalikSystem.getLocalVariableAddress(charCode), 1, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawCharacter: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacters(char[] src, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = src.length;
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(true, Array.getFirstElementAddress(src), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawCharacters: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacters(char[] src, int offset, int length, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("RasterCanvas.drawCharacters", src.length, offset, length);
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(true, Array.getFirstElementAddress(src) + (offset << 1), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawCharacters: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacters(int[] src, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = src.length;
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(false, Array.getFirstElementAddress(src), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawCharacters: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCharacters(int[] src, int offset, int length, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("RasterCanvas.drawCharacters: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("RasterCanvas.drawCharacters", src.length, offset, length);
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(false, Array.getFirstElementAddress(src) + (offset << 1), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawCharacters: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(String string, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (string == null) {
            throw new NullPointerException("RasterCanvas.drawString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = string.length();
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(true, Array.getFirstElementAddress(string), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawString: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSubstring(String string, int offset, int length, int x, int y, Paint paint) {
        boolean strikeout;
        boolean underline;
        SystemFont font;
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawSubstring: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (string == null) {
            throw new NullPointerException("RasterCanvas.drawSubstring: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String.checkBound("RasterCanvas.drawSubstring", string.length(), offset, length);
        if (paint instanceof TextPaint) {
            TextPaint tpaint = (TextPaint)paint;
            font = tpaint.getFont();
            underline = tpaint.isUnderline();
            strikeout = tpaint.isStrikeout();
        } else {
            font = SystemFont.getDefault();
            underline = false;
            strikeout = false;
        }
        boolean error = false;
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                StringDrawDescriptor dst = this.getStringDescriptor();
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignString(true, Array.getFirstElementAddress(string) + (offset << 1), length, x - clipLeft, y - clipTop, color, font.getHandle(), underline, strikeout, alpha);
                if (font.isSystem()) {
                    if (length > 0) {
                        MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                    }
                } else {
                    Object object2 = SystemFont.monitor();
                    synchronized (object2) {
                        if (!font.isInstalled()) {
                            error = true;
                        } else if (length > 0) {
                            MalikSystem.syscall((long)dst.getDescriptorAddress(), 45);
                        }
                    }
                }
            }
        }
        if (error) {
            throw new UninstalledFontException("RasterCanvas.drawSubstring: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPixel(int x, int y, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawHorizontalLine: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && x < clipRight && x >= clipLeft && y < clipBottom && y >= clipTop) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignStretch(src, 0, x - clipLeft, y - clipTop, 1, 1);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawHorizontalLine(int x, int y, int length, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawHorizontalLine: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (length <= 0) {
            return;
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && x < clipRight && x + length > clipLeft && y < clipBottom && y >= clipTop) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignStretch(src, 0, x - clipLeft, y - clipTop, length, 1);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawVerticalLine(int x, int y, int length, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawVerticalLine: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (length <= 0) {
            return;
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && x < clipRight && x >= clipLeft && y < clipBottom && y + length > clipTop) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignStretch(src, 0, x - clipLeft, y - clipTop, 1, length);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCustom(Drawable figure, int x, int y, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.drawCustom: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (figure == null) {
            throw new NullPointerException("RasterCanvas.drawCustom: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 figure \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        x += paint.getTranslateX();
        y += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                figure.draw(this.getDrawableRender(x - clipLeft, y - clipTop));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRectangle(int left, int top, int width, int height, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.fillRectangle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        left += paint.getTranslateX();
        top += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignStretch(src, 0, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRectangle(Rectangle region, Paint paint) {
        if (paint == null) {
            throw new NullPointerException("RasterCanvas.fillRectangle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 paint \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (region == null) {
            throw new NullPointerException("RasterCanvas.fillRectangle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int left = region.getLeft();
        int top = region.getTop();
        int width = region.getWidth();
        int height = region.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean alpha = paint.hasAlpha();
        int color = paint.getColor();
        left += paint.getTranslateX();
        top += paint.getTranslateY();
        int clipLeft = paint.getLeft();
        int clipTop = paint.getTop();
        int clipRight = clipLeft + paint.getWidth();
        int clipBottom = clipTop + paint.getHeight();
        if (clipLeft < 0) {
            clipLeft = 0;
        }
        if (clipTop < 0) {
            clipTop = 0;
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.width;
            if (clipRight > len) {
                clipRight = len;
            }
            if (clipBottom > (len = this.height)) {
                clipBottom = len;
            }
            if (clipLeft < clipRight && clipTop < clipBottom && left < clipRight && left + width > clipLeft && top < clipBottom && top + height > clipTop) {
                RasterBufferDescriptor src = this.getRasterDescriptor();
                StretchDrawDescriptor dst = this.getStretchDescriptor();
                src.assignBuffer(MalikSystem.getLocalVariableAddress(color), 1, 1, 1, alpha);
                dst.assignBuffer(this.buffer, clipLeft, clipTop, clipRight - clipLeft, clipBottom - clipTop);
                dst.assignStretch(src, 0, left - clipLeft, top - clipTop, width, height);
                MalikSystem.syscall((long)dst.getDescriptorAddress(), 39);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("RasterCanvas.setSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("RasterCanvas.setSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            RasterBuffer b = this.buffer;
            if (width > b.getWidth()) {
                error = 1;
            } else if (height > b.getHeight()) {
                error = 2;
            } else {
                this.sizeChanged = true;
                this.width = width;
                this.height = height;
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("RasterCanvas.setSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IllegalArgumentException("RasterCanvas.setSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getPixels(RasterBuffer buffer, int left, int top) {
        if (buffer == null) {
            throw new NullPointerException("RasterCanvas.getPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 buffer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int width = buffer.getWidth();
            int lim = left + width;
            int len = this.width;
            if (lim > len || lim < left || left > len || left < 0) {
                error = true;
            } else {
                int height = buffer.getHeight();
                lim = top + height;
                if (lim > (len = this.height) || lim < top || top > len || top < 0) {
                    error = true;
                } else {
                    RasterBuffer thisBuffer = this.buffer;
                    int[] pixels = buffer.getPixels();
                    int jstep = buffer.getScanlength();
                    int istep = thisBuffer.getScanlength();
                    int[] thisPixels = thisBuffer.getPixels();
                    int i = thisBuffer.getOffset() + left + top * istep;
                    int j = buffer.getOffset();
                    int k = height;
                    while (k-- > 0) {
                        Array.copy(thisPixels, i, pixels, j, width);
                        i += istep;
                        j += jstep;
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("RasterCanvas.getPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateScreen() {
        if ((this.flags & 2) == 0) {
            throw new IllegalStateException("RasterCanvas.updateScreen: \u044d\u0442\u0430 \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u0430\u044f \u043a\u0430\u043d\u0432\u0430 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0440\u0430\u043d\u043e\u043c.");
        }
        if (this.sizeChanged) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.sizeChanged) {
                    this.sizeChanged = false;
                    RasterBufferDescriptor r = this.getRasterDescriptor();
                    r.assignBuffer(this.buffer, 0, 0, this.width, this.height);
                    MalikSystem.syscall(0, r.getDescriptorAddress(), 35);
                }
            }
        }
        MalikSystem.syscall(0L, 32);
    }

    public final boolean isScreen() {
        return (this.flags & 2) != 0;
    }

    public final boolean isOpaque() {
        return (this.flags & 1) != 0;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final RasterBuffer getBuffer() {
        return this.buffer;
    }

    private PrimitiveRender getDrawableRender(int x, int y) {
        PrimitiveRender result = this.drawableRender;
        if (result == null) {
            result = this.drawableRender = new PrimitiveRender(this.rasterDescriptor, this.stretchDescriptor);
        }
        result.setCoordinates(x, y);
        return result;
    }

    private StringDrawDescriptor getStringDescriptor() {
        StringDrawDescriptor result = this.stringDescriptor;
        if (result == null) {
            result = this.stringDescriptor = new StringDrawDescriptor();
        }
        return result;
    }

    private GUIElementDescriptor getElementDescriptor() {
        GUIElementDescriptor result = this.elementDescriptor;
        if (result == null) {
            result = this.elementDescriptor = new GUIElementDescriptor();
        }
        return result;
    }

    private StretchDrawDescriptor getStretchDescriptor() {
        StretchDrawDescriptor result = this.stretchDescriptor;
        if (result == null) {
            result = this.stretchDescriptor = new StretchDrawDescriptor();
        }
        return result;
    }

    private RasterBufferDescriptor getRasterDescriptor() {
        RasterBufferDescriptor result = this.rasterDescriptor;
        if (result == null) {
            result = this.rasterDescriptor = new RasterBufferDescriptor();
        }
        return result;
    }
}

