/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.sound;

import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;

public abstract class SoundPlayer {
    public static final int MUTE = 0;
    public static final int MAX_VOLUME = 127;
    public static final int FREED = 0;
    public static final int STARTED = 1;
    public static final int STOPPED = 2;
    protected SoundPlayerListener listener;

    protected SoundPlayer() {
    }

    public abstract int loadBlock(long[] var1, int var2, int var3) throws SoundPlayerException;

    public abstract int reset() throws SoundPlayerException;

    public abstract int start() throws SoundPlayerException;

    public abstract int stop() throws SoundPlayerException;

    public abstract int setCurrentBlockPosition(int var1) throws SoundPlayerException;

    public abstract int getState() throws SoundPlayerException;

    public abstract int getVolume() throws SoundPlayerException;

    public abstract int getCurrentBlockIndex() throws SoundPlayerException;

    public abstract int getCurrentBlockPosition() throws SoundPlayerException;

    public void close() {
    }

    public void setSoundPlayerListener(SoundPlayerListener listener) {
        this.listener = listener;
    }

    public int setVolume(int volume) throws SoundPlayerException {
        return volume < 0 ? 0 : (volume > 127 ? 127 : volume);
    }

    public long getCurrentBlockIndexAndPosition() throws SoundPlayerException {
        return (long)this.getCurrentBlockIndex() << 32 | (long)this.getCurrentBlockPosition() & 0xFFFFFFFFL;
    }
}

