/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.Calendar;
import java.util.TimeZone;
import malik.emulator.time.CalendarSystem;

public final class CLDCCalendar
extends Calendar {
    private final CalendarSystem system;

    public CLDCCalendar(CalendarSystem system) {
        this.system = system;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected void computeTime() {
        int[] flds = this.fields;
        TimeZone zone = this.getTimeZone();
        this.correctFields();
        int tmp = flds[1];
        int n = tmp < 1 ? 1 : tmp;
        tmp = flds[2] + 1;
        this.time = this.system.computeTime(n, tmp < 1 ? 1 : (tmp > 12 ? 12 : tmp), flds[5], flds[11], flds[12], flds[13], flds[14], zone != null ? zone.getRawOffset() : 0);
    }

    protected void computeFields() {
        CalendarSystem system = this.system;
        TimeZone zone = this.getTimeZone();
        long time = zone != null ? this.time + (long)zone.getRawOffset() : this.time;
        long fields = system.computeFields(time, 0);
        int[] flds = this.fields;
        long days = (time + system.epochStart()) / 86400000L;
        flds[1] = (int)(fields >>> 48);
        flds[2] = ((int)(fields >> 40) & 0xFF) - 1;
        flds[5] = (int)(fields >> 32) & 0xFF;
        flds[7] = (int)((days + 1L) % 7L) + 1;
        int tmp = (int)(fields >> 24) & 0xFF;
        flds[9] = tmp < 12 ? 0 : 1;
        int h = tmp % 12;
        flds[10] = h == 0 ? 12 : h;
        flds[11] = tmp;
        flds[12] = (int)(fields >> 16) & 0xFF;
        tmp = (int)fields & 0xFFFF;
        flds[13] = tmp / 1000;
        flds[14] = tmp % 1000;
    }

    private void correctFields() {
        boolean[] sets = this.isSet;
        int[] flds = this.fields;
        if (sets[11]) {
            int hour;
            flds[11] = hour = Math.abs(flds[11] % 24);
            flds[9] = hour < 12 ? 0 : 1;
            sets[11] = false;
            return;
        }
        if (sets[9]) {
            int ampm = flds[9];
            if (ampm != 0 && ampm != 1) {
                flds[9] = flds[11] < 12 ? 0 : 1;
            }
            sets[9] = false;
        }
        if (sets[10]) {
            int hour = flds[10];
            if (hour > 12) {
                flds[11] = hour % 12 + 12;
                flds[10] = hour % 12;
                flds[9] = 1;
            } else {
                flds[11] = flds[9] == 1 ? hour + 12 : hour;
            }
            sets[10] = false;
        }
    }
}

