{
    Исходный код проекта Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

program Emulator;

{$MODE DELPHI}

uses
    {$IF DEFINED(UNIX) AND DEFINED(USECTHREADS)}CThreads,{$ENDIF}
    (* HeapTrc { Это включает детектор утечек памяти }, *)
    Interfaces { Это подключает набор виджетов LCL },
    Forms { Это использует тело программы },
    Dialogs { Это использует тело программы },
    TranslateApplication { Это переведёт некоторые ресурсные строки на язык приложения (русский) },

    { Список общих модулей, которые необходимы этой программе }
    Lang,
    IntelMMX,
    IOStreams,
    FileIO,
    TextFiles,
    SettingFiles,
    Zlib,
    ReadZIP,
    Images,
    UFonts,
    Manifests,
    Timers,
    Players,

    { Вы можете добавлять свои модули в этот список }
    EmulMalik,
    EmulConstants,
    EmulProgrammes,
    PixelGraphicScaling,
    PixelGraphicNearNeighbour,
    PixelGraphicSimpleScaling,
    PixelGraphicHighQualityScaling,
    PixelGraphicPhotographicScaling,

    { Вы можете добавлять свои темы интерфейса пользователя в этот список модулей }
    EmulThemes,
    EmulThemeSoft,

    { Вы можете добавлять свои статические рекомпиляторы в этот список модулей }
    StaticRecompilers,
    StringPools,
    JavaRecompiler,

    { Вы можете добавлять модули окон и рамок приложения в этот список модулей }
    InvisibleWindow,
    EmulatorInterfaces,
    FileBrowsingWindow,
    DirectoryBrowsingWindow,
    DisassemblerWindow,
    EmulationWindow,
    ProgrammePropertiesWindow,
    InstallWindow,
    InstallProcessWindow,
    UninstallProcessWindow,
    RunningListWindow,
    SettingsWindow,
    AboutWindow,
    ProgrammesListFrame,
    MainWindow;

{$R *.RES}

begin
    if not IntelMMX.mmxSupported() then begin
        messageDlg('Отсутствует технология Intel MMX', 'Процессор не поддерживает технологию Intel MMX. Запуск Малик Эмулятора невозможен.', mtError, [mbClose], 0);
        exit;
    end;
    Forms.requireDerivedFormResource := true;
    application.initialize();
    application.title := 'Малик Эмулятор';
    application.extendedKeysSupport := false;
    TInvisibleForm.createInstance();
    TMainForm.createInstance();
    application.run();
end.

