{
    DirectoryBrowsingWindow используется для создания окна, в котором пользователь
    смотрит папки на своём компьютере и выбирает одну папку для обработки
    Малик Эмулятором.
    Этот исходный текст является частью Малик Эмулятора.

    Следующие файлы используются этим исходным текстом:
        directorybrowsingwindow.lfm
    На них так же распространяются те же права, как и на этот исходный текст.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit DirectoryBrowsingWindow;

{$MODE DELPHI}

interface

uses
    Classes,
    SysUtils,
    Forms,
    ShellCtrls,
    StdCtrls,
    Lang,
    Manifests,
    EmulatorInterfaces;

{%region public }
type
    TDirectoryBrowser = class(TForm)
        directoriesView: TShellTreeView;
        selectButton: TButton;
        cancelButton: TButton;
    private
        owner: MainWindowInterface;
    public
        constructor create(theOwner: TComponent); override;
        procedure afterConstruction(); override;
        procedure beforeDestruction(); override;
        procedure setDirectory(const directory: AnsiString);
        function getDirectory(): AnsiString;
    end;
{%endregion}

implementation

{$R *.LFM}

{%region TDirectoryBrowser }
    constructor TDirectoryBrowser.create(theOwner: TComponent);
    begin
        inherited create(theOwner);
        theOwner.getInterface(stringToGUID(MAIN_WINDOW_INTERFACE_GUID), owner);
    end;

    procedure TDirectoryBrowser.afterConstruction();
    var
        sizes: AnsiString_Array1d;
    begin
        inherited afterConstruction();
        sizes := getComponents(owner.getSetting(SECTION_WINDOWS, KEY_DIRECTORY_BROWSER, toDecString(width) + ',' + toDecString(height)));
        if length(sizes) >= 2 then begin
            width := parseDecInt(sizes[0], width);
            height := parseDecInt(sizes[1], height);
        end;
    end;

    procedure TDirectoryBrowser.beforeDestruction();
    begin
        owner.setSetting(SECTION_WINDOWS, KEY_DIRECTORY_BROWSER, toDecString(width) + ',' + toDecString(height));
        inherited beforeDestruction();
    end;

    procedure TDirectoryBrowser.setDirectory(const directory: AnsiString);
    begin
        directoriesView.path := directory;
    end;

    function TDirectoryBrowser.getDirectory(): AnsiString;
    begin
        result := directoriesView.path;
    end;
{%endregion}

end.

