/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.bluetooth;

import javax.microedition.io.*;
import javax.microedition.lcdui.*;

public class LocalDevice extends Object
{
	private static final LocalDevice INSTANCE;

	static
	{
		INSTANCE = new LocalDevice();
	}

	public static boolean isPowerOn()
	{
		return true;
	}

	public static String getProperty(String key)
	{
		return key == null || !key.startsWith("bluetooth.") ? null : System.getProperty(key);
	}

	public static LocalDevice getLocalDevice()
			throws BluetoothStateException
	{
		return INSTANCE;
	}


	private int discoverable;
	private DiscoveryAgent agent;

	private LocalDevice()
	{
		this.discoverable = DiscoveryAgent.NOT_DISCOVERABLE;
		this.agent = new DiscoveryAgent();
	}

	public void updateRecord(ServiceRecord record)
			throws ServiceRegistrationException
	{
		if(record == null)
		{
			throw new NullPointerException("LocalDevice.updateRecord: " +
					"параметр record равен нулевой ссылке.");
		}
	}

	public boolean setDiscoverable(int mode)
			throws BluetoothStateException
	{
		if(mode != DiscoveryAgent.NOT_DISCOVERABLE &&
				(mode < DiscoveryAgent.MIN_DISCOVERABLE || mode > DiscoveryAgent.MAX_DISCOVERABLE))
		{
			throw new IllegalArgumentException("LocalDevice.setDiscoverable: " +
					"недопустимое значение параметра mode.");
		}
		this.discoverable = mode;
		return true;
	}

	public int getDiscoverable()
	{
		return discoverable;
	}

	public String getFriendlyName()
	{
		return MIDletProxy.getInstance().getMIDletDescriptor().get("MIDlet-Name");
	}

	public String getBluetoothAddress()
	{
		return "0000000021CD";
	}

	public DeviceClass getDeviceClass()
	{
		return null;
	}

	public DiscoveryAgent getDiscoveryAgent()
	{
		return agent;
	}

	public ServiceRecord getRecord(Connection notifier)
	{
		throw new IllegalArgumentException("LocalDevice.getRecord: " +
				"недопустимое значение параметра notifier.");
	}
}
