/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

import malik.emulator.util.*;

public final class Long extends Object
{
	public static final long MIN_VALUE = 0x8000000000000000L;
	public static final long MAX_VALUE = 0x7fffffffffffffffL;

	public static long parseLong(String string) throws NumberFormatException
	{
		return parseLong(string, 10);
	}

	public static long parseLong(String string, int radix) throws NumberFormatException
	{
		boolean negative;
		int i;
		int len;
		long digit;
		long limit;
		long mulmin;
		long result;
		if(string == null || (len = string.length()) <= 0)
		{
			throw new NumberFormatException("Long.parseLong: недопустимый формат числа.");
		}
		if(radix > Character.MAX_RADIX)
		{
			throw new NumberFormatException((new StringBuilder()).append("Long.parseLong: основание системы счисления (").append(radix).append(") больше, чем Character.MAX_RADIX.").toString());
		}
		if(radix < Character.MIN_RADIX)
		{
			throw new NumberFormatException((new StringBuilder()).append("Long.parseLong: основание системы счисления (").append(radix).append(") меньше, чем Character.MIN_RADIX.").toString());
		}
		result = 0;
		if(string.charAt(i = 0) == '-')
		{
			i++;
			negative = true;
			limit = 0x8000000000000000L;
		} else
		{
			negative = false;
			limit = 0x8000000000000001L;
		}
		mulmin = limit / (long) radix;
		if(i < len)
		{
			if((digit = (long) Character.digit(string.charAt(i++), radix)) < 0)
			{
				throw new NumberFormatException("Long.parseLong: недопустимый формат числа.");
			}
			result = -digit;
		}
		while(i < len)
		{
			if((digit = (long) Character.digit(string.charAt(i++), radix)) < 0 || result < mulmin || (result *= (long) radix) < limit + digit)
			{
				throw new NumberFormatException("Long.parseLong: недопустимый формат числа.");
			}
			result -= digit;
		}
		if(negative)
		{
			if(i <= 1)
			{
				throw new NumberFormatException("Long.parseLong: недопустимый формат числа.");
			}
			return result;
		}
		return -result;
	}

	public static String toString(long value)
	{
		return toString(value, 10);
	}

	public static String toString(long value, int radix)
	{
		boolean negative = value < 0;
		int i;
		int len = (i = 64) + 1;
		char[] buf = new char[len];
		if(radix > Character.MAX_RADIX || radix < Character.MIN_RADIX) radix = 10;
		if(!negative) value = -value;
		for(long posradix, negradix = -(posradix = (long) radix); value <= negradix; buf[i--] = Character.getDigitRepresentation((int) -(value % posradix)), value /= posradix);
		buf[i] = Character.getDigitRepresentation((int) -value);
		if(negative) buf[--i] = '-';
		return new String(buf, i, len - i);
	}


	private final long value;

	public Long(long value)
	{
		this.value = value;
	}

	public boolean equals(Object anot)
	{
		return anot == this || anot instanceof Long && value == ((Long) anot).value;
	}

	public int hashCode()
	{
		long bits;
		return (int) ((bits = value) ^ (bits >> 32));
	}

	public String toString()
	{
		return toString(value, 10);
	}

	public float floatValue()
	{
		return (float) value;
	}

	public double doubleValue()
	{
		return (double) value;
	}

	public long longValue()
	{
		return value;
	}
}
