﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.i18n;

import java.io.*;

public abstract class StreamReader extends Reader
{
	private InputStream stream;

	protected StreamReader()
	{
	}

	public abstract int read(char[] dst, int offset, int length)
			throws IOException;

	public abstract int sizeOf(byte[] src, int offset, int length);

	public void close()
			throws IOException
	{
		InputStream stream;
		if((stream = this.stream) == null)
		{
			return;
		}
		this.stream = null;
		this.lock = null;
		stream.close();
	}

	public void reset()
			throws IOException
	{
		ensureOpen().reset();
	}

	public void mark(int readLimit)
			throws IOException
	{
		InputStream stream;
		if(!(stream = ensureOpen()).markSupported())
		{
			throw new IOException("Reader.mark: " +
					"класс " + stream.getClass().getName() + " не поддерживает метод mark.");
		}
		stream.mark(readLimit);
	}

	public boolean markSupported()
	{
		InputStream stream;
		return (stream = this.stream) != null && stream.markSupported();
	}

	public boolean ready()
			throws IOException
	{
		return ensureOpen().available() > 0;
	}

	protected final InputStream ensureOpen()
			throws IOException
	{
		InputStream result;
		if((result = stream) == null)
		{
			throw new IOException("InputStreamReader: " +
					"символьный поток закрыт.");
		}
		return result;
	}

	final Reader open(InputStream stream)
	{
		this.stream = stream;
		return this;
	}
}
