﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.i18n.encoding.system;

import java.io.*;
import malik.emulator.i18n.*;

public class UTF_8_Writer extends StreamWriter
{
	public UTF_8_Writer()
	{
	}

	public void write(char[] src, int offset, int length)
			throws IOException
	{
		int i;
		int inputChar;
		int outputSize;
		byte[] output = new byte[3];
		OutputStream stream = ensureOpen();
		for(i = 0; i < length; i++)
		{
			if((inputChar = (int) src[offset++]) > 0x0000 && inputChar < 0x0080)
			{
				output[0] = (byte) inputChar;
				outputSize = 1;
			}
			else if(inputChar < 0x0800)
			{
				output[0] = (byte) (0xc0 | ((inputChar >> 6) & 0x1f));
				output[1] = (byte) (0x80 | (inputChar & 0x3f));
				outputSize = 2;
			}
			else
			{
				output[0] = (byte) (0xe0 | ((inputChar >> 12) & 0x0f));
				output[1] = (byte) (0x80 | ((inputChar >> 6) & 0x3f));
				output[2] = (byte) (0x80 | (inputChar & 0x3f));
				outputSize = 3;
			}
			stream.write(output, 0, outputSize);
		}
	}

	public int sizeOf(char[] src, int offset, int length)
	{
		int result;
		int inputChar;
		for(result = 0; offset < length; )
		{
			result += (inputChar = src[offset++]) > 0x0000 && inputChar < 0x0080 ? 1 :
					(inputChar < 0x0800 ? 2 : 3);
		}
		return result;
	}
}
