/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.time;

import java.util.*;

public class LocaleTimeZone extends TimeZone
{
	public static char[] offsetToString(int offsetInMillis)
	{
		boolean negative;
		int ofs;
		int hrs;
		int min = (hrs = (negative = (ofs = offsetInMillis / 60000) < 0) ? -ofs : ofs) % 60;
		hrs /= 60;
		return new char[] {
				negative ? '-' : '+',
				(char) (((hrs / 10) % 10) + '0'),
				(char) ((hrs % 10) + '0'), ':',
				(char) ((min / 10) + '0'),
				(char) ((min % 10) + '0')
		};
	}


	private int offset;
	private String[] ids;
	private String id;
	private String name;

	public LocaleTimeZone(int offsetInMillis, String id)
	{
		this(offsetInMillis, id, null, null);
	}

	public LocaleTimeZone(int offsetInMillis, String id, String name)
	{
		this(offsetInMillis, id, name, null);
	}

	public LocaleTimeZone(int offsetInMillis, String id, String name, String[] ids)
	{
		int len = ids != null ? ids.length : 0;
		String[] list;
		this.offset = offsetInMillis;
		this.ids = list = ids != null ? new String[len] : null;
		this.id = id != null && id.length() != 0 ? id :
				"UTC".concat(String.valueOf(offsetToString(offsetInMillis)));
		this.name = name;
		if(list == null)
		{
			return;
		}
		Array.copy(ids, 0, list, 0, len);
	}

	public boolean equals(Object obj)
	{
		LocaleTimeZone zone;
		return obj == this || obj instanceof LocaleTimeZone &&
				offset == (zone = (LocaleTimeZone) obj).offset &&
				id.equals(zone.id);
	}

	public boolean useDaylightTime()
	{
		return false;
	}

	public int hashCode()
	{
		return offset ^ id.hashCode();
	}

	public int getOffset(int era, int year, int month, int day, int weekDay, int millis)
	{
		return offset;
	}

	public String toString()
	{
		StringBuffer result;
		String name;
		result = (new StringBuffer()).append("(UTC");
		if((offset / 60000) != 0)
		{
			result.append(offsetToString(offset));
		}
		result.append(")");
		if((name = getName()) != null && (name = name.trim()).length() > 0)
		{
			result.append(' ').append(name);
		}
		return result.toString();
	}

	public String toString(int era, int year, int month, int day, int weekday, int millis)
	{
		return toString();
	}

	public String getName()
	{
		return name;
	}

	public String getName(int era, int year, int month, int day, int weekday, int millis)
	{
		return getName();
	}

	public final int getRawOffset()
	{
		return offset;
	}

	public final String getID()
	{
		return id;
	}

	public final boolean isID(String id)
	{
		int i;
		String[] ids;
		if(id != null && id.equals(this.id))
		{
			return true;
		}
		if((ids = this.ids) == null)
		{
			return false;
		}
		for(i = ids.length; i-- > 0; )
		{
			if(id != null ? id.equals(ids[i]) : ids[i] == null)
			{
				return true;
			}
		}
		return false;
	}

	public final int getIDsCount()
	{
		String[] ids;
		return (ids = this.ids) == null ? 1 : ids.length + 1;
	}

	public final String getID(int index)
	{
		String[] ids;
		if(index < 0 || index > ((ids = this.ids) == null ? 0 : ids.length))
		{
			throw new IndexOutOfBoundsException("LocaleTimeZone.getID: " +
					"индекс выходит из диапазона.");
		}
		return index == 0 ? id : ids[index - 1];
	}
}
