﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.i18n.encoding;

public class CP1251_Codec extends OneByteCodec
{
	public static int decodeByte(int byteValue)
	{
		if(byteValue >= 0x00 && byteValue <= 0x7f)
		{
			return byteValue;
		}
		if(byteValue >= 0xc0 && byteValue <= 0xff)
		{
			return byteValue + 0x0350;
		}
		switch(byteValue)
		{
		default:
			return 0x0000;
		case 0x80:
			return 0x0402;
		case 0x81:
			return 0x0403;
		case 0x82:
			return 0x201a;
		case 0x83:
			return 0x0453;
		case 0x84:
			return 0x201e;
		case 0x85:
			return 0x2026;
		case 0x86:
			return 0x2020;
		case 0x87:
			return 0x2021;
		case 0x88:
			return 0x20ac;
		case 0x89:
			return 0x2030;
		case 0x8a:
			return 0x0409;
		case 0x8b:
			return 0x2039;
		case 0x8c:
			return 0x040a;
		case 0x8d:
			return 0x040c;
		case 0x8e:
			return 0x040b;
		case 0x8f:
			return 0x040f;
		case 0x90:
			return 0x0452;
		case 0x91:
			return 0x2018;
		case 0x92:
			return 0x2019;
		case 0x93:
			return 0x201c;
		case 0x94:
			return 0x201d;
		case 0x95:
			return 0x2022;
		case 0x96:
			return 0x2013;
		case 0x97:
			return 0x2014;
		case 0x99:
			return 0x2122;
		case 0x9a:
			return 0x0459;
		case 0x9b:
			return 0x203a;
		case 0x9c:
			return 0x045a;
		case 0x9d:
			return 0x045c;
		case 0x9e:
			return 0x045b;
		case 0x9f:
			return 0x045f;
		case 0xa0:
			return 0x00a0;
		case 0xa1:
			return 0x040e;
		case 0xa2:
			return 0x045e;
		case 0xa3:
			return 0x0408;
		case 0xa4:
			return 0x00a4;
		case 0xa5:
			return 0x0490;
		case 0xa6:
			return 0x00a6;
		case 0xa7:
			return 0x00a7;
		case 0xa8:
			return 0x0401;
		case 0xa9:
			return 0x00a9;
		case 0xaa:
			return 0x0404;
		case 0xab:
			return 0x00ab;
		case 0xac:
			return 0x00ac;
		case 0xad:
			return 0x00ad;
		case 0xae:
			return 0x00ae;
		case 0xaf:
			return 0x0407;
		case 0xb0:
			return 0x00b0;
		case 0xb1:
			return 0x00b1;
		case 0xb2:
			return 0x0406;
		case 0xb3:
			return 0x0456;
		case 0xb4:
			return 0x0491;
		case 0xb5:
			return 0x00b5;
		case 0xb6:
			return 0x00b6;
		case 0xb7:
			return 0x00b7;
		case 0xb8:
			return 0x0451;
		case 0xb9:
			return 0x2116;
		case 0xba:
			return 0x0454;
		case 0xbb:
			return 0x00bb;
		case 0xbc:
			return 0x0458;
		case 0xbd:
			return 0x0405;
		case 0xbe:
			return 0x0455;
		case 0xbf:
			return 0x0457;
		}
	}

	public static int encodeChar(int charCode)
	{
		if(charCode >= 0x0000 && charCode <= 0x007f)
		{
			return charCode;
		}
		if(charCode >= 0x0410 && charCode <= 0x044f)
		{
			return charCode - 0x0350;
		}
		switch(charCode)
		{
		default:
			return '?';
		case 0x0402:
			return 0x80;
		case 0x0403:
			return 0x81;
		case 0x201a:
			return 0x82;
		case 0x0453:
			return 0x83;
		case 0x201e:
			return 0x84;
		case 0x2026:
			return 0x85;
		case 0x2020:
			return 0x86;
		case 0x2021:
			return 0x87;
		case 0x20ac:
			return 0x88;
		case 0x2030:
			return 0x89;
		case 0x0409:
			return 0x8a;
		case 0x2039:
			return 0x8b;
		case 0x040a:
			return 0x8c;
		case 0x040c:
			return 0x8d;
		case 0x040b:
			return 0x8e;
		case 0x040f:
			return 0x8f;
		case 0x0452:
			return 0x90;
		case 0x2018:
			return 0x91;
		case 0x2019:
			return 0x92;
		case 0x201c:
			return 0x93;
		case 0x201d:
			return 0x94;
		case 0x2022:
			return 0x95;
		case 0x2013:
			return 0x96;
		case 0x2014:
			return 0x97;
		case 0x2122:
			return 0x99;
		case 0x0459:
			return 0x9a;
		case 0x203a:
			return 0x9b;
		case 0x045a:
			return 0x9c;
		case 0x045c:
			return 0x9d;
		case 0x045b:
			return 0x9e;
		case 0x045f:
			return 0x9f;
		case 0x00a0:
			return 0xa0;
		case 0x040e:
			return 0xa1;
		case 0x045e:
			return 0xa2;
		case 0x0408:
			return 0xa3;
		case 0x00a4:
			return 0xa4;
		case 0x0490:
			return 0xa5;
		case 0x00a6:
			return 0xa6;
		case 0x00a7:
			return 0xa7;
		case 0x0401:
			return 0xa8;
		case 0x00a9:
			return 0xa9;
		case 0x0404:
			return 0xaa;
		case 0x00ab:
			return 0xab;
		case 0x00ac:
			return 0xac;
		case 0x00ad:
			return 0xad;
		case 0x00ae:
			return 0xae;
		case 0x0407:
			return 0xaf;
		case 0x00b0:
			return 0xb0;
		case 0x00b1:
			return 0xb1;
		case 0x0406:
			return 0xb2;
		case 0x0456:
			return 0xb3;
		case 0x0491:
			return 0xb4;
		case 0x00b5:
			return 0xb5;
		case 0x00b6:
			return 0xb6;
		case 0x00b7:
			return 0xb7;
		case 0x0451:
			return 0xb8;
		case 0x2116:
			return 0xb9;
		case 0x0454:
			return 0xba;
		case 0x00bb:
			return 0xbb;
		case 0x0458:
			return 0xbc;
		case 0x0405:
			return 0xbd;
		case 0x0455:
			return 0xbe;
		case 0x0457:
			return 0xbf;
		}
	}


	public CP1251_Codec()
	{
	}

	protected int decode(int byteValue)
	{
		return decodeByte(byteValue);
	}

	protected int encode(int charCode)
	{
		return encodeChar(charCode);
	}
}
