﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.fileformats.sound.synthetic;

import malik.emulator.fileformats.sound.*;

/**
 * Интерфейс для всех декодеров музыки, которую можно привести к стандарту MIDI.
 * Это только базовый интерфейс: позволяет извлекать только голосовые сообщения, которые можно
 * отправлять в секвенсор.
 * Единственный класс <code>MIDIDecoder</code>, который реализует этот интерфейс, декодирует
 * форматы MID и MIDI.
 * @author Малик Разработчик
 */
public interface SoundDecoderSynthetic
		extends SoundDecoder
{
	/**
	 * Возвращает массив сообщений MIDI с отметками во времени. Каждое сообщение имеет тип
	 * <code>long</code> и имеет следующую структуру:<p />
	 * биты 63-24 – время в миллисекундах, когда сообщение будет отправлено в секвенсор.
	 * Отсчитывается от времени начала проигрывания, весь массив сообщений будет отсортирован по
	 * этому полю;<br />
	 * биты 23-16 – статус-байт MIDI;<br />
	 * биты 15-08 – байт данных 1;<br />
	 * биты 07-00 – байт данных 2.<p />
	 * Первый элемент массива в битах 63-24 содержит нули.<p />
	 * Последний элемент массива содержит в битах 63-24 продолжительность звучания, а биты
	 * 23-00 имеют вид <code>0xff2f00</code> (статус-байт MIDI равен <code>0xff</code>,
	 * байт данных 1 равен <code>0x2f</code>, байт данных 2 равен <code>0x00</code>).<p />
	 * Будет ли эта функция возвращать один и тот же массив при каждом вызове или каждый раз будет
	 * конструировать новый – полностью зависит от реализации.<p />
	 * Возвращаемое значение этой функции равно нулевой ссылке или массиву нулевой длины, если
	 * декодер пуст.
	 * @return массив сообщений MIDI.
	 */
	public long[] getMessages();
}
