/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import java.io.*;
import malik.emulator.midp.*;

public class ShowMemoryStatusCommand extends ConsoleCommand
{
	private static final long KB = 1L << 10;
	private static final long MB = 1L << 20;
	private static final long GB = 1L << 30;
	private static final long TB = 1L << 40;
	private static final long PB = 1L << 50;
	private static final long EB = 1L << 60;

	public static void printDataSize(PrintStream printer, int size, boolean precission)
	{
		printer.print(dataSizeToString(size, precission));
	}

	public static void printDataSize(PrintListener printer, int size, boolean precission)
	{
		printer.print(dataSizeToString(size, precission));
	}

	public static String dataSizeToString(int size, boolean precission)
	{
		long lsize;
		if(size >= 0 && size < KB)
		{
			return Integer.toString(size).concat(" байт");
		}
		if(size >= KB && size < MB)
		{
			return precission ? Integer.toString(size >> 10) + " КБ (" + size + " байт)" :
					Integer.toString(size >> 10) + " КБ";
		}
		if(size >= MB && size < GB)
		{
			return precission ? Integer.toString(size >> 20) + " МБ (" + size + " байт)" :
					Integer.toString(size >> 20) + " МБ";
		}
		lsize = ((long) size) & 0xffffffffL;
		return precission ? Long.toString(lsize >> 30) + " ГБ (" + lsize + "байт)" :
				Long.toString(lsize >> 30) + " ГБ";
	}

	public static String dataSizeToString(long size)
	{
		if(size >= 0 && size < KB) return Integer.toString((int) (size)).concat(" байт");
		if(size >= KB && size < MB) return Integer.toString((int) (size >> 10)).concat(" КБ");
		if(size >= MB && size < GB) return Integer.toString((int) (size >> 20)).concat(" МБ");
		if(size >= GB && size < TB) return Integer.toString((int) (size >> 30)).concat(" ГБ");
		if(size >= TB && size < PB) return Integer.toString((int) (size >> 40)).concat(" ТБ");
		if(size >= PB && size < EB) return Integer.toString((int) (size >> 50)).concat(" ПБ");
		return Integer.toString((int) (size >>> 60)).concat(" ЭБ");
	}


	public ShowMemoryStatusCommand()
	{
		super("память",
				"Использование:\n" +
				"  память\n" +
				"  память точно\n" +
				"Выводит на консоль состояние памяти.");
	}

	public void run(String[] arguments)
	{
		boolean precission;
		ConsoleScreen console;
		if((console = getConsoleScreen()) == null)
		{
			return;
		}
		precission = arguments.length > 0 && "точно".equals(arguments[0]);
		console.print("Всего: ");
		console.print(dataSizeToString(Memory.getTotal(), precission));
		console.print("\nСвободно: ");
		console.print(dataSizeToString(Memory.getFree(), precission));
		console.print("\nОсвобождено: ");
		console.print(dataSizeToString(Memory.getCollected()));
		console.println();
	}
}
