/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package com.samsung.util;

public class SM extends Object
{
	private String address;
	private String passText;

	public SM()
	{
	}

	public SM(String destAddress, String thisAddress, String passText)
	{
		char c;
		int i;
		if(address != null)
		{
			for(i = address.length(); i-- > 0; )
			{
				if(((c = address.charAt(i)) < '0' || c > '9') && (i > 0 || c != '+'))
				{
					throw new IllegalArgumentException("SM: " +
							"недопустимое значение параметра address.");
				}
			}
		}
		if(passText != null && passText.length() > 80)
		{
			throw new IllegalArgumentException("SM: " +
					"параметр passText имеет большую длину (допустимо 80 символов максимум).");
		}
		this.address = destAddress;
		this.passText = passText;
	}

	public void setCallbackAddress(String address)
	{
	}

	public void setDestAddress(String address)
	{
		char c;
		int i;
		if(address != null)
		{
			for(i = address.length(); i-- > 0; )
			{
				if(((c = address.charAt(i)) < '0' || c > '9') && (i > 0 || c != '+'))
				{
					throw new IllegalArgumentException("SM.setDestAddress: " +
							"недопустимое значение параметра address.");
				}
			}
		}
		this.address = address;
	}

	public void setData(String passText)
	{
		if(passText != null && passText.length() > 80)
		{
			throw new IllegalArgumentException("SM: " +
					"параметр passText имеет большую длину (допустимо 80 символов максимум).");
		}
		this.passText = passText;
	}

	public String getCallbackAddress()
	{
		return null;
	}

	public String getDestAddress()
	{
		return address;
	}

	public String getData()
	{
		return passText;
	}

	final String getRealAddress()
	{
		return address;
	}

	final String getRealPassText()
	{
		return passText;
	}
}
