/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.util;

import malik.emulator.time.*;
import malik.emulator.util.*;

public class Date extends Object
{
    private long millis;

    public Date() {
        this.millis = System.currentTimeMillis();
    }

    public Date(long time) {
        this.millis = time;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Date && millis == ((Date) anot).millis;
    }

    public int hashCode() {
        long millis;
        return (int) ((millis = this.millis) ^ (millis >> 32));
    }

    public String toString() {
        int year;
        int month;
        int day;
        int weekday;
        int hour;
        int minute;
        int second;
        long fields;
        String string;
        TimeZone zone;
        StringBuilder result;
        CalendarSystem calendar;
        fields = (calendar = CalendarSystem.gregorian).computeFields(millis, (zone = TimeZone.getDefault()).getRawOffset());
        year = calendar.getYear(fields);
        month = calendar.getMonth(fields);
        day = calendar.getDay(fields);
        weekday = calendar.computeDayOfWeek(year, month, day);
        hour = calendar.getHour(fields);
        minute = calendar.getMinute(fields);
        second = calendar.getSecond(fields);
        result = new StringBuilder(24);
        switch(weekday)
        {
        case CalendarSystem.MONDAY:
            result.append("Mon");
            break;
        case CalendarSystem.TUESDAY:
            result.append("Tue");
            break;
        case CalendarSystem.WEDNESDAY:
            result.append("Wed");
            break;
        case CalendarSystem.THURSDAY:
            result.append("Thu");
            break;
        case CalendarSystem.FRIDAY:
            result.append("Fri");
            break;
        case CalendarSystem.SATURDAY:
            result.append("Sat");
            break;
        default:
            result.append("Sun");
            break;
        }
        result.append(' ');
        switch(month)
        {
        case CalendarSystem.JANUARY:
            result.append("Jan");
            break;
        case CalendarSystem.FEBRUARY:
            result.append("Feb");
            break;
        case CalendarSystem.MARCH:
            result.append("Mar");
            break;
        case CalendarSystem.APRIL:
            result.append("Apr");
            break;
        case CalendarSystem.MAY:
            result.append("May");
            break;
        case CalendarSystem.JUNE:
            result.append("Jun");
            break;
        case CalendarSystem.JULY:
            result.append("Jul");
            break;
        case CalendarSystem.AUGUST:
            result.append("Aug");
            break;
        case CalendarSystem.SEPTEMBER:
            result.append("Sep");
            break;
        case CalendarSystem.OCTOBER:
            result.append("Oct");
            break;
        case CalendarSystem.NOVEMBER:
            result.append("Nov");
            break;
        default:
            result.append("Dec");
            break;
        }
        result.append(new char[] {
            ' ', (char) (day / 10 + '0'), (char) (day % 10 + '0'), ' ', (char) (hour / 10 + '0'), (char) (hour % 10 + '0'), ':',
            (char) (minute / 10 + '0'), (char) (minute % 10 + '0'), ':', (char) (second / 10 + '0'), (char) (second % 10 + '0'), ' '
        }).append(zone.toString()).append(' ');
        switch((string = Integer.toString(year, 10)).length())
        {
        case 1:
            result.append("000").append(string);
            break;
        case 2:
            result.append("00").append(string);
            break;
        case 3:
            result.append("0").append(string);
            break;
        default:
            result.append(string);
            break;
        }
        return result.toString();
    }

    public void setTime(long time) {
        this.millis = time;
    }

    public long getTime() {
        return millis;
    }
}
