﻿/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.io.vfs;

public class FileAttributes extends Object
{
    /* Время в формате System.currentTimeMillis() */
    public static final int READ_ONLY = 0x0001;
    public static final int HIDDEN = 0x0002;
    public static final int SYSTEM = 0x0004;
    public static final int DIRECTORY = 0x0010;
    public static final int ARCHIVE = 0x0020;

    private int attributes;
    private long creationTime;
    private long lastWriteTime;
    private long lastAccessTime;

    public FileAttributes() {
    }

    public FileAttributes(FileAttributes source) {
        if(source == null) return;
        this.attributes = source.attributes;
        this.creationTime = source.creationTime;
        this.lastWriteTime = source.lastWriteTime;
        this.lastAccessTime = source.lastAccessTime;
    }

    public FileAttributes(int attributes, long creationTime, long lastWriteTime, long lastAccessTime) {
        this.attributes = attributes & (READ_ONLY | HIDDEN | SYSTEM | DIRECTORY | ARCHIVE);
        this.creationTime = creationTime;
        this.lastWriteTime = lastWriteTime;
        this.lastAccessTime = lastAccessTime;
    }

    public void setAttributes(int attributes, long creationTime, long lastWriteTime, long lastAccessTime) {
        this.attributes = attributes & (READ_ONLY | HIDDEN | SYSTEM | DIRECTORY | ARCHIVE);
        this.creationTime = creationTime;
        this.lastWriteTime = lastWriteTime;
        this.lastAccessTime = lastAccessTime;
    }

    public final boolean isDirectory() {
        return (attributes & DIRECTORY) != 0;
    }

    public final boolean isReadOnly() {
        return (attributes & READ_ONLY) != 0;
    }

    public final boolean isArchive() {
        return (attributes & ARCHIVE) != 0;
    }

    public final boolean isHidden() {
        return (attributes & HIDDEN) != 0;
    }

    public final boolean isSystem() {
        return (attributes & SYSTEM) != 0;
    }

    public final int getAttributes() {
        return attributes;
    }

    public final long getCreationTime() {
        return creationTime;
    }

    public final long getLastWriteTime() {
        return lastWriteTime;
    }

    public final long getLastAccessTime() {
        return lastAccessTime;
    }
}
