/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n.encoding;

import java.io.*;
import malik.emulator.i18n.*;

public class OneByteWriter extends StreamWriter
{
    private final OneByteCodec encoder;

    public OneByteWriter(OneByteCodec encoder) {
        super(new Object());
        if(encoder == null)
        {
            throw new NullPointerException("OneByteWriter: аргумент encoder равен нулевой ссылке.");
        }
        this.encoder = encoder;
    }

    protected OneByteWriter() {
        super(new Object());
        String name;
        this.encoder = OneByteCodec.get((name = getClass().getName()).substring(0, name.lastIndexOf('_') + 1).concat("Codec"));
    }

    public final void write(int character) throws IOException {
        OutputStream stream = getOutputStream();
        OneByteCodec encoder = this.encoder;
        synchronized(lock)
        {
            stream.write(encoder.encode(character & 0xffff));
        }
    }

    public final void write(char[] src) throws IOException {
        super.write(src);
    }

    public final void write(char[] src, int offset, int length) throws IOException {
        OutputStream stream = getOutputStream();
        OneByteCodec encoder = this.encoder;
        synchronized(lock)
        {
            for(int lim = offset + length; offset < lim; offset++) stream.write(encoder.encode(src[offset]));
        }
    }

    public final void write(String src) throws IOException {
        OutputStream stream = getOutputStream();
        OneByteCodec encoder = this.encoder;
        synchronized(lock)
        {
            for(int len = src == null ? 0 : src.length(), i = 0; i < len; i++) stream.write(encoder.encode(src.charAt(i)));
        }
    }

    public final void write(String src, int offset, int length) throws IOException {
        OutputStream stream = getOutputStream();
        OneByteCodec encoder = this.encoder;
        synchronized(lock)
        {
            for(int lim = offset + length; offset < lim; offset++) stream.write(encoder.encode(src.charAt(offset)));
        }
    }
}
