/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package com.nokia.mid.ui;

import java.io.*;
import javax.microedition.lcdui.*;
import malik.emulator.fileformats.graphics.*;
import malik.emulator.microedition.*;

public class DirectUtils extends Object
{
    public static DirectGraphics getDirectGraphics(Graphics render) {
        return render;
    }

    public static Image createImage(int width, int height, int colorARGB) {
        int area;
        int[] pixels;
        if(width <= 0)
        {
            throw new IllegalArgumentException("DirectUtils.createImage: аргумент width может быть только положительным.");
        }
        if(height <= 0)
        {
            throw new IllegalArgumentException("DirectUtils.createImage: аргумент height может быть только положительным.");
        }
        Array.fill(pixels = new int[area = width * height], 0, area, colorARGB);
        return Image.createRGBImage(pixels, width, height, true, true);
    }

    public static Image createImage(byte[] src, int offset, int length) {
        int width;
        int height;
        int[] pixels;
        ImageDecoder decoder;
        if(src == null)
        {
            throw new NullPointerException("DirectUtils.createImage: аргумент src равен нулевой ссылке.");
        }
        Array.checkBound("DirectUtils.createImage", src.length, offset, length);
        try
        {
            InputStream stream = new ByteArrayInputStream(src, offset, length);
            (decoder = DeviceManager.getInstance().openImageDecoder(stream)).loadFromInputStream(stream);
        }
        catch(Exception e)
        {
            throw new IllegalArgumentException("DirectUtils.createImage: не удалось декодировать изображение.");
        }
        width = decoder.getWidth();
        height = decoder.getHeight();
        pixels = decoder.getPixels();
        if(!decoder.alphaSupported()) for(int i = width * height; i-- > 0; pixels[i] |= 0xff000000);
        return Image.createRGBImage(pixels, width, height, true, true);
    }

    private DirectUtils() {
    }
}
