/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.*;
import malik.emulator.application.*;

public class ScreenScrollBarStyle extends ScrollBarStyle
{
    private static final int TRACK_MARGIN_EDGE = 3;
    private static final int TRACK_MARGIN_ENDS = 1;
    private static final int SLIDER_MARGIN_EDGE = 2;
    private static final int SLIDER_MINIMUM_LENGTH = 7;

    private static final int[] TRACK_COLORS;
    private static final int[] SLIDER_MARGINS_COLORS;

    static {
        TRACK_COLORS = new int[] { 0x60609f, 0x7a7aaf, 0x9595bf, 0xafafcf };
        SLIDER_MARGINS_COLORS = new int[] { 0x02ffffff, 0x01f3f3f3, 0x00e7e7e7, 0x00dbdbdb, 0x00cfcfcf, 0x01c3c3c3, 0x02b7b7b7 };
    }

    private boolean focused;

    public ScreenScrollBarStyle() {
        super(11);
    }

    public void horizontalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        int p;
        int x;
        int sl;
        int x1;
        int x2;
        int page;
        int range;
        switch(event.getAction())
        {
        case PointerEvent.ACTION_POINTER_PRESSED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page)
            {
                x = event.getX();
                sl = getSliderLength(page, range, width, SLIDER_MINIMUM_LENGTH);
                x1 = getSliderPosition(page, range, scrollbar.getPosition(), width, sl);
                x2 = sl + x1 - 1;
                if(x < x1)
                {
                    scrollbar.scroll(-page);
                    break;
                }
                if(x > x2)
                {
                    scrollbar.scroll(page);
                    break;
                }
                focused = true;
            }
            break;
        case PointerEvent.ACTION_BUTTON_PRESSED:
        case PointerEvent.ACTION_POINTER_DRAGGED:
        case PointerEvent.ACTION_BUTTON_RELEASED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page && focused)
            {
                x = event.getX();
                p = event.historicalX(1);
                scrollbar.scroll((int) ((double) (x - p) * (double) range / (double) width));
            }
            break;
        case PointerEvent.ACTION_POINTER_RELEASED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page && focused)
            {
                x = event.getX();
                p = event.historicalX(1);
                scrollbar.scroll((int) ((double) (x - p) * (double) range / (double) width));
            }
            focused = false;
            break;
        }
    }

    public void horizontalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        int sl;
        int x1;
        int x2;
        int page;
        int range;
        x2 = width - (TRACK_MARGIN_ENDS + 1);
        for(int y = TRACK_MARGIN_EDGE, len = TRACK_COLORS.length, i = 0; i < len; y++, i++)
        {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(TRACK_MARGIN_ENDS, y, x2, y);
        }
        if((page = scrollbar.getPage()) <= 0 || (range = scrollbar.getRange()) <= page) return;
        sl = getSliderLength(page, range, width, SLIDER_MINIMUM_LENGTH);
        x1 = getSliderPosition(page, range, scrollbar.getPosition(), width, sl);
        x2 = sl + x1 - 1;
        for(int y = SLIDER_MARGIN_EDGE, len = SLIDER_MARGINS_COLORS.length, i = 0; i < len; y++, i++)
        {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(x1 + (c >>= 24), y, x2 - c, y);
        }
    }

    public void verticalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        int p;
        int y;
        int sl;
        int y1;
        int y2;
        int page;
        int range;
        switch(event.getAction())
        {
        case PointerEvent.ACTION_POINTER_PRESSED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page)
            {
                y = event.getY();
                sl = getSliderLength(page, range, height, SLIDER_MINIMUM_LENGTH);
                y1 = getSliderPosition(page, range, scrollbar.getPosition(), height, sl);
                y2 = sl + y1 - 1;
                if(y < y1)
                {
                    scrollbar.scroll(-page);
                    break;
                }
                if(y > y2)
                {
                    scrollbar.scroll(page);
                    break;
                }
                focused = true;
            }
            break;
        case PointerEvent.ACTION_BUTTON_PRESSED:
        case PointerEvent.ACTION_POINTER_DRAGGED:
        case PointerEvent.ACTION_BUTTON_RELEASED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page && focused)
            {
                y = event.getY();
                p = event.historicalY(1);
                scrollbar.scroll((int) ((double) (y - p) * (double) range / (double) height));
            }
            break;
        case PointerEvent.ACTION_POINTER_RELEASED:
            if((page = scrollbar.getPage()) > 0 && (range = scrollbar.getRange()) > page && focused)
            {
                y = event.getY();
                p = event.historicalY(1);
                scrollbar.scroll((int) ((double) (y - p) * (double) range / (double) height));
            }
            focused = false;
            break;
        }
    }

    public void verticalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        int sl;
        int y1;
        int y2;
        int page;
        int range;
        y2 = height - (TRACK_MARGIN_ENDS + 1);
        for(int x = TRACK_MARGIN_EDGE, len = TRACK_COLORS.length, i = 0; i < len; x++, i++)
        {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(x, TRACK_MARGIN_ENDS, x, y2);
        }
        if((page = scrollbar.getPage()) <= 0 || (range = scrollbar.getRange()) <= page) return;
        sl = getSliderLength(page, range, height, SLIDER_MINIMUM_LENGTH);
        y1 = getSliderPosition(page, range, scrollbar.getPosition(), height, sl);
        y2 = sl + y1 - 1;
        for(int x = SLIDER_MARGIN_EDGE, len = SLIDER_MARGINS_COLORS.length, i = 0; i < len; x++, i++)
        {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(x, y1 + (c >>= 24), x, y2 - c);
        }
    }
}
