/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.media;

import javax.microedition.media.*;

public class ControlList extends Object implements Controllable
{
    public static final Control[] empty;

    static {
        empty = new Control[0];
    }

    protected Control[] controls;

    public ControlList() {
        this.controls = empty;
    }

    public ControlList(Control[] controls) {
        this.controls = controls == null || controls.length <= 0 ? empty : controls;
    }

    public Control[] getControls() {
        int len;
        Control[] result;
        if((result = controls) == null || (len = result.length) <= 0) return empty;
        Array.copy(result, 0, result = new Control[len], 0, len);
        return result;
    }

    public Control getControl(String controlTypeName) {
        int len;
        Control[] controls;
        Class controlType;
        Class basicType;
        if(controlTypeName == null)
        {
            throw new IllegalArgumentException("Controllable.getControl: аргумент controlTypeName равен нулевой ссылке.");
        }
        if((controls = this.controls) == null || (len = controls.length) <= 0) return null;
        if(controlTypeName.indexOf('.') < 0) controlTypeName = "javax.microedition.media.control.".concat(controlTypeName);
        try
        {
            controlType = Class.forName(controlTypeName);
            basicType = Class.forName("javax.microedition.media.Control");
        }
        catch(ClassNotFoundException e)
        {
            return null;
        }
        for(int i = !controlType.isInterface() || !basicType.isAssignableFrom(controlType) ? 0 : len; i-- > 0; )
        {
            Control current;
            if((current = controls[i]) != null && controlType.isAssignableFrom(current.getClass())) return current;
        }
        return null;
    }
}
