/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system;

import java.io.*;
import malik.emulator.io.cloud.*;
import malik.emulator.microedition.*;

public class ConsoleOutputStream extends FileOutputStream
{
    private static boolean DOUBLE_OUTPUT;

    static {
        DOUBLE_OUTPUT = true;
    }

    public static void setDoubleOutput(boolean doubleOutput) {
        DOUBLE_OUTPUT = doubleOutput;
    }

    public static boolean isDoubleOutput() {
        return DOUBLE_OUTPUT;
    }

    private int textColor;
    private Console console;

    public ConsoleOutputStream(String fileName, int textColor) {
        this(fileName, false, textColor);
    }

    public ConsoleOutputStream(String fileName, boolean appending, int textColor) {
        super(fileName, appending);
        this.textColor = textColor & 0xffffff;
    }

    public void write(int byteData) throws IOException {
        Console console;
        if(DOUBLE_OUTPUT && (console = getConsole()) != null) console.print(new String(new byte[] { (byte) byteData }), textColor);
        super.write(byteData);
    }

    public void write(byte[] src, int offset, int length) throws IOException {
        Console console;
        if(DOUBLE_OUTPUT && (console = getConsole()) != null) console.print(new String(src, offset, length), textColor);
        super.write(src, offset, length);
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor & 0xffffff;
    }

    public int getTextColor() {
        return textColor;
    }

    private Console getConsole() {
        Console result;
        DeviceManager manager;
        if((result = console) == null && (manager = DeviceManager.getInstance()) instanceof SystemManager) result = console = ((SystemManager) manager).console;
        return result;
    }
}
