/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.console;

import malik.emulator.microedition.*;
import malik.emulator.microedition.system.*;

public class FramesPerSecondConsoleCommand extends ConsoleCommand
{
    public FramesPerSecondConsoleCommand() {
        super(
            "квс",
            "Использование:\n квс\n квс <целое число от 1 до 99>\nВариант без аргумента выводит на консоль установленный максимум частоты кадров в секунду.\n" +
            "Вариант с одним аргументом задаёт новый максимум частоты кадров в секунду."
        );
    }

    protected void execute(String[] arguments, Console console) {
        int value = -1;
        if(arguments.length > 0)
        {
            try
            {
                if((value = Integer.parseInt(arguments[0])) < 1) value = 1;
                if(value > 99) value = 99;
            }
            catch(NumberFormatException e)
            {
            }
        }
        if(value > 0)
        {
            DeviceManager.getInstance().getSettings().setMaximumFrequency(value);
        } else
        {
            value = DeviceManager.getInstance().getSettings().getMaximumFrequency();
        }
        console.println("Максимум кадров в секунду: ".concat(Integer.toString(value)));
    }
}
