/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.obex;

import java.io.*;

public interface HeaderSet
{
    public static final int NAME                  = 0x01; // String
    public static final int DESCRIPTION           = 0x05; // String
    public static final int TYPE                  = 0x42; // String
    public static final int TIME_ISO_8601         = 0x44; // Calendar
    public static final int TARGET                = 0x46; // byte[]
    public static final int HTTP                  = 0x47; // byte[]
    public static final int WHO                   = 0x4a; // byte[]
    public static final int APPLICATION_PARAMETER = 0x4c; // byte[]
    public static final int OBJECT_CLASS          = 0x4f; // byte[]
    public static final int COUNT                 = 0xc0; // Long
    public static final int LENGTH                = 0xc3; // Long
    public static final int TIME_4_BYTE           = 0xc4; // Calendar

    public void createAuthenticationChallenge(String realm, boolean userID, boolean access);

    public void setHeader(int headerID, Object headerValue);

    public int getResponseCode() throws IOException;

    public int[] getHeaderList() throws IOException;

    public Object getHeader(int headerID) throws IOException;
}
