{
    EmulConstants содержит константы, используемые Малик Эмулятором.
    Этот исходный текст является частью Малик Эмулятора.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit EmulConstants;

{$MODE DELPHI}

interface

uses
    Lang;

{%region public }
const
    MIN_SCREEN_WIDTH = int(96);
    MIN_SCREEN_HEIGHT = int(64);
    MAX_SCREEN_WIDTH = int(1024);
    MAX_SCREEN_HEIGHT = int(768);
    DEFAULT_SCREEN_WIDTH = int(240);
    DEFAULT_SCREEN_HEIGHT = int(320);

const
    MANIFEST_PROPERTY_PROGRAMME_NAME = 'Programme-Name';
    MANIFEST_PROPERTY_PROGRAMME_ICON = 'Programme-Icon';
    MANIFEST_PROPERTY_PROGRAMME_EXECUTABLE = 'Programme-Executable';
    MANIFEST_PROPERTY_PROGRAMME_DESCRIPTION = 'Programme-Description';
    MANIFEST_PROPERTY_PROGRAMME_VERSION = 'Programme-Version';
    MANIFEST_PROPERTY_PROGRAMME_VENDOR = 'Programme-Vendor';
    MANIFEST_PROPERTY_PROGRAMME_SITE = 'Programme-Info-URL';
    MANIFEST_PROPERTY_PROGRAMME_INSTALL_NOTIFY = 'Programme-Install-Notify';
    MANIFEST_PROPERTY_PROGRAMME_DELETE_CONFIRM = 'Programme-Delete-Confirm';
    MANIFEST_PROPERTY_PROGRAMME_DELETE_NOTIFY = 'Programme-Delete-Notify';
    { MANIFEST_PROPERTY_MALIK_CATEGORY = 'Malik-Programme-Category';
      // не используется: пользователь волен устанавливать программу абсолютно в любую папку }
    MANIFEST_PROPERTY_MALIK_SCREEN_SIZE = 'Malik-Programme-Screen-Size';
    MANIFEST_PROPERTY_AGE_CATEGORY = 'Age-Category';
    MANIFEST_PROPERTY_SOURCE_PLATFORM = 'Source-Platform';

const
    MANIFEST_PROPERTY_MIDLET_CONFIGURATION = 'MicroEdition-Configuration';
    MANIFEST_PROPERTY_MIDLET_PROFILE = 'MicroEdition-Profile';
    MANIFEST_PROPERTY_MIDLET_NAME = 'MIDlet-Name';
    MANIFEST_PROPERTY_MIDLET_ICON = 'MIDlet-Icon';
    MANIFEST_PROPERTY_MIDLET_DESCRIPTION = 'MIDlet-Description';
    MANIFEST_PROPERTY_MIDLET_VERSION = 'MIDlet-Version';
    MANIFEST_PROPERTY_MIDLET_VENDOR = 'MIDlet-Vendor';
    MANIFEST_PROPERTY_MIDLET_SITE = 'MIDlet-Info-URL';
    MANIFEST_PROPERTY_MIDLET_INSTALL_NOTIFY = 'MIDlet-Install-Notify';
    MANIFEST_PROPERTY_MIDLET_DELETE_CONFIRM = 'MIDlet-Delete-Confirm';
    MANIFEST_PROPERTY_MIDLET_DELETE_NOTIFY = 'MIDlet-Delete-Notify';
    MANIFEST_PROPERTY_MIDLET_NOKIA_CATEGORY = 'Nokia-MIDlet-Category';

var
    MANIFEST_PROPERTY_MIDLET_SITE_ATLERNATIVES: AnsiString_Array1d;
{%endregion}

implementation

initialization {%region}
    MANIFEST_PROPERTY_MIDLET_SITE_ATLERNATIVES := toStringArray1d([
        'SiteURL'
    ]);
{%endregion}

end.

