{
    AboutWindow используется для создания окна, в котором пользователь
    смотрит сведения о программе.
    Этот исходный текст является частью Малик Эмулятора.

    Следующие файлы используются этим исходным текстом:
        aboutwindow.lfm
    На них так же распространяются те же права, как и на этот исходный текст.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit AboutWindow;

{$MODE DELPHI}

interface

uses
    Classes,
    SysUtils,
    Forms,
    ComCtrls,
    StdCtrls,
    ExtCtrls,
    Menus,
    UTF8Process,
    Lang,
    StaticRecompilers;

{%region public }
type
    TAboutForm = class(TForm)
        viewLinkBrowser: TProcessUTF8;
        pagesMain: TPageControl;
        tabVersion: TTabSheet;
        imgLogo: TImage;
        labelEmulatorVersion: TLabel;
        viewEmulatorVersion: TLabel;
        labelBuildDate: TLabel;
        viewBuildDate: TLabel;
        labelSupportedPlatforms: TLabel;
        viewSupportedPlatforms: TMemo;
        viewCopyright: TLabel;
        tabInternet: TTabSheet;
        panelInternet: TPanel;
        outpanelLinkMain: TPanel;
        backLinkMain: TShape;
        labelLinkMain: TLabel;
        inpanelLinkMain: TPanel;
        descLinkMain: TLabel;
        btnLinkMain: TButton;
        qrLinkMain: TImage;
        outpanelLinkDonate: TPanel;
        backLinkDonate: TShape;
        labelLinkDonate: TLabel;
        inpanelLinkDonate: TPanel;
        descLinkDonate: TLabel;
        btnLinkDonate: TButton;
        qrLinkDonate: TImage;
        tabShortcut: TTabSheet;
        viewShortcut: TMemo;
        tabAuthors: TTabSheet;
        viewAuthors: TMemo;
        tabLicense: TTabSheet;
        viewLicense: TMemo;
        btnClose: TButton;
        procedure formCreate(sender: TObject);
        procedure buttonClick(sender: TObject);
    private
        { private declarations }
    public
        { public declarations }
    end;
{%endregion}

implementation

{$R *.LFM}

{%region TAboutForm }
    procedure TAboutForm.formCreate(sender: TObject);
    var
        i: int;
        date: AnsiString;
        list: TStrings;
    begin
        { заполняем дату сборки }
        date := {$I %DATE%};
        for i := length(date) downto 1 do begin
            if date[i] = '/' then begin
                date[i] := '-';
            end;
        end;
        viewBuildDate.caption := date;
        { заполняем список поддерживаемых платформ }
        list := viewSupportedPlatforms.lines;
        list.beginUpdate();
        try
            list.clear();
            for i := StaticRecompilers.getRecompilersCount() - 1 downto 0 do begin
                list.insert(0, StaticRecompilers.getRecompiler(i).getPlatformName());
            end;
        finally
            list.endUpdate();
        end;
    end;

    procedure TAboutForm.buttonClick(sender: TObject);
    var
        len: int;
        tempAString: AnsiString;
    begin
        if sender is TButton then with viewLinkBrowser, parameters do begin
            tempAString := getEnvironmentVariable('SystemRoot');
            len := length(tempAString);
            if (len <= 0) or (tempAString[len] <> DIRECTORY_SEPARATOR) then begin
                tempAString := tempAString + DIRECTORY_SEPARATOR;
            end;
            executable := tempAString + 'explorer.exe';
            clear();
            add(TButton(sender).caption);
            execute();
            exit;
        end;
    end;
{%endregion}

end.

