﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public abstract class InputStream extends Object
{
	public InputStream()
	{
	}

	public abstract int read()
			throws IOException;

	public void close()
			throws IOException
	{
	}

	public void reset()
			throws IOException
	{
		throw new IOException("InputStream.reset: " +
				"класс " + getClass().getName() + " не поддерживает метод reset.");
	}

	public void mark(int readLimit)
	{
	}

	public boolean markSupported()
	{
		return false;
	}

	public int read(byte[] dst)
			throws IOException
	{
		int data;
		int length;
		int result;
		if(dst == null)
		{
			throw new NullPointerException("InputStream.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		for(length = dst.length, result = 0; result < length; )
		{
			if((data = read()) < 0)
			{
				break;
			}
			dst[result++] = (byte) data;
		}
		return result;
	}

	public int read(byte[] dst, int offset, int length)
			throws IOException
	{
		int lim;
		int len;
		int data;
		int result;
		if(dst == null)
		{
			throw new NullPointerException("InputStream.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = dst.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("InputStream.read: " +
					"индекс выходит из диапазона.");
		}
		for(result = 0; result < length; result++)
		{
			if((data = read()) < 0)
			{
				break;
			}
			dst[offset++] = (byte) data;
		}
		return result;
	}

	public int available()
			throws IOException
	{
		return 0;
	}

	public long skip(long bytesCount)
			throws IOException
	{
		long remaining;
		for(remaining = bytesCount; remaining > 0L && read() >= 0; remaining--);
		return bytesCount - remaining;
	}
}
