/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

public final class Boolean extends Object
{
	public static final Boolean TRUE;
	public static final Boolean FALSE;

	static
	{
		TRUE = new Boolean(true);
		FALSE = new Boolean(false);
	}


	private final boolean value;

	public Boolean(boolean value)
	{
		this.value = value;
	}

	public boolean equals(Object anot)
	{
		return anot == this || anot instanceof Boolean && value == ((Boolean) anot).value;
	}

	public int hashCode()
	{
		return value ? 1231 : 1237;
	}

	public String toString()
	{
		return value ? "true" : "false";
	}

	public boolean booleanValue()
	{
		return value;
	}
}
