/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

public final class Byte extends Object
{
	public static final byte MIN_VALUE = 0xffffff80;
	public static final byte MAX_VALUE = 0x0000007f;

	public static byte parseByte(String string) throws NumberFormatException
	{
		int value = Integer.parseInt(string, 10);
		if(value < MIN_VALUE || value > MAX_VALUE)
		{
			throw new NumberFormatException("Byte.parseByte: недопустимый формат числа.");
		}
		return (byte) value;
	}

	public static byte parseByte(String string, int radix) throws NumberFormatException
	{
		int value = Integer.parseInt(string, radix);
		if(value < MIN_VALUE || value > MAX_VALUE)
		{
			throw new NumberFormatException("Byte.parseByte: недопустимый формат числа.");
		}
		return (byte) value;
	}


	private final int value;

	public Byte(byte value)
	{
		this.value = value;
	}

	public boolean equals(Object anot)
	{
		return anot == this || anot instanceof Byte && value == ((Byte) anot).value;
	}

	public int hashCode()
	{
		return value;
	}

	public String toString()
	{
		return Integer.toString(value, 10);
	}

	public byte byteValue()
	{
		return (byte) value;
	}
}
