/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

import malik.emulator.time.*;

public class Date extends Object
{
	private long millis;
	private Calendar calendar;

	public Date()
	{
		this(System.currentTimeMillis());
	}

	public Date(long millis)
	{
		Calendar c;
		this.millis = millis;
		this.calendar = c = Calendar.getInstance();
		if(c != null)
		{
			c.setTimeInMillis(millis);
		}
	}

	public boolean equals(Object ref)
	{
		return ref == this || ref instanceof Date && getTime() == ((Date) ref).getTime();
	}

	public int hashCode()
	{
		long t;
		return (int) ((t = getTime()) ^ (t >>> 32));
	}

	public String toString()
	{
		int ms;
		long f;
		long t;
		Calendar c;
		TimeZone z;
		return ((c = calendar) != null && c instanceof GregorianCalendar) ?
				(
					((GregorianCalendar) c).toString(GregorianCalendar.getStandardFormat())
				) :
				(
					GregorianCalendar.getStandardFormat().represent(1,
							(int) ((f = GregorianCalendar.computeFields(t = getTime(),
							(z = TimeZone.getDefault()).getRawOffset())) >>> 48),
							((byte) (f >>> 40)) - 1, (byte) (f >>> 32),
							((((int) ((t / 86400000L) % 7L)) + 1) % 7) + 1,
							(byte) (f >>> 24), (byte) (f >>> 16),
							(ms = ((int) f) & 0xffff) / 1000, ms % 1000, z)
				);
	}

	public void setTime(long millis)
	{
		Calendar c;
		this.millis = millis;
		if((c = calendar) != null)
		{
			c.setTimeInMillis(millis);
		}
	}

	public long getTime()
	{
		Calendar c;
		return (c = calendar) != null ? c.getTimeInMillis() : millis;
	}
}
