/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

import malik.emulator.time.*;

public abstract class TimeZone extends Object
{
	public static String[] getAvailableIDs()
	{
		int i;
		int j;
		int len;
		String[] result;
		LocaleTimeZone z;
		for(len = 0, i = ListOfTimeZones.length(); i-- > 0; )
		{
			len += (z = ListOfTimeZones.getTimeZone(i)) != null ? z.getIDsCount() : 0;
		}
		result = new String[len];
		for(len = 0, i = ListOfTimeZones.length(); i-- > 0; )
		{
			if((z = ListOfTimeZones.getTimeZone(i)) == null)
			{
				continue;
			}
			for(j = z.getIDsCount(); j-- > 0; )
			{
				result[len++] = z.getID(j);
			}
		}
		return result;
	}

	public static TimeZone getTimeZone(String id)
	{
		return ListOfTimeZones.getTimeZone(id);
	}

	public static TimeZone getDefault()
	{
		return ListOfTimeZones.getDefault();
	}


	public TimeZone()
	{
	}

	public abstract boolean useDaylightTime();

	public abstract int getRawOffset();

	public abstract int getOffset(int era, int year,
			int month, int day, int dayOfWeek, int millis);

	public String getID()
	{
		return null;
	}
}
