/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.media.graphics;

import malik.emulator.util.*;

class GraphicBufferDescriptor extends SystemDescriptor
{
	public int base;
	public int scan;
	public int sizes;

	GraphicBufferDescriptor()
	{
	}

	public final void assign(int base, int scanlength, int width, int height)
	{
		this.base = base;
		this.scan = scanlength;
		this.sizes = (width & 0xffff) | (height << 16);
	}

	public final void assign(int[] pixels, int offset, int scanlength, int width, int height)
	{
		this.base = Array.getFirstElementAddress(pixels) + (offset << 2);
		this.scan = scanlength;
		this.sizes = (width & 0xffff) | (height << 16);
	}

	public final void assign(GraphicBuffer buffer, int cleft, int ctop, int cwidth, int cheight)
	{
		int s;
		this.base = buffer.getBase() + ((cleft + ctop * (s = buffer.getScanlength())) << 2);
		this.scan = s;
		this.sizes = (cwidth & 0xffff) | (cheight << 16);
	}
}
