/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public abstract class CustomItem extends Item
{
	protected static final int NONE = 0x00;
	protected static final int TRAVERSE_HORIZONTAL = 0x01;
	protected static final int TRAVERSE_VERTICAL = 0x02;
	protected static final int KEY_PRESS = 0x04;
	protected static final int KEY_RELEASE = 0x08;
	protected static final int KEY_REPEAT = 0x10;
	protected static final int POINTER_PRESS = 0x20;
	protected static final int POINTER_RELEASE = 0x40;
	protected static final int POINTER_DRAG = 0x80;


	private boolean pointerFocused;

	protected CustomItem(String label)
	{
		super(LAYOUT_DEFAULT, -1, -1, label, null, null, null);
	}

	protected CustomItem(int layout, int lockedWidth, int lockedHeight, String label,
			Command[] commands, Command defaultCommand, ItemCommandListener listener)
	{
		super(layout, lockedWidth, lockedHeight, label, commands, defaultCommand, listener);
	}

	public int getGameAction(int keyCode)
	{
		return MIDletProxy.getInstance().keyCodeToGameAction(keyCode);
	}

	protected abstract void paint(Graphics render, int contentWidth, int contentHeight);

	protected abstract int getMinContentWidth();

	protected abstract int getMinContentHeight();

	protected abstract int getPrefContentWidth(int contentHeight);

	protected abstract int getPrefContentHeight(int contentWidth);

	protected void showNotify()
	{
	}

	protected void hideNotify()
	{
	}

	protected void keyPressed(int keyCode)
	{
	}

	protected void keyRepeated(int keyCode)
	{
	}

	protected void keyReleased(int keyCode)
	{
	}

	protected void pointerPressed(int x, int y)
	{
	}

	protected void pointerDragged(int x, int y)
	{
	}

	protected void pointerReleased(int x, int y)
	{
	}

	protected void sizeChanged(int contentWidth, int contentHeight)
	{
	}

	protected void traverseOut()
	{
	}

	protected boolean traverse(int direction, int viewportWidth, int viewportHeight,
			int[] visibleRectangle)
	{
		return false;
	}

	protected final void invalidate()
	{
		notifyUpdate();
	}

	protected final void repaint()
	{
		notifyPaint();
	}

	protected final void repaint(int left, int top, int width, int height)
	{
		notifyPaint();
	}

	protected final int getInteractionModes()
	{
		return -1;
	}

	void paintContent(Graphics render, int contentWidth, int contentHeight)
	{
		paint(render, contentWidth, contentHeight);
	}

	void onShow()
	{
		showNotify();
	}

	void onHide()
	{
		hideNotify();
	}

	void onSizeChanged(int contentWidth, int contentHeight)
	{
		sizeChanged(contentWidth, contentHeight);
	}

	void onKeyPressed(int key, int charCode)
	{
		int keyCode;
		if((keyCode = MIDletProxy.getInstance().getKeyCode(key)) == 0)
		{
			return;
		}
		keyPressed(keyCode);
	}

	void onKeyRepeated(int key, int charCode)
	{
		int keyCode;
		if((!Canvas.isKeyRepeatedEvent()) ||
				(keyCode = MIDletProxy.getInstance().getKeyCode(key)) == 0)
		{
			return;
		}
		keyRepeated(keyCode);
	}

	void onKeyReleased(int key)
	{
		int keyCode;
		if((keyCode = MIDletProxy.getInstance().getKeyCode(key)) == 0)
		{
			return;
		}
		keyReleased(keyCode);
	}

	void onContentPointerPressed(int x, int y, int button)
	{
		if(button != MIDletProxy.BUTTON_MAIN)
		{
			return;
		}
		pointerFocused = true;
		pointerPressed(x, y);
	}

	void onContentPointerDragged(int x, int y)
	{
		if(!pointerFocused)
		{
			return;
		}
		pointerDragged(x, y);
	}

	void onContentPointerReleased(int x, int y, int button)
	{
		if((!pointerFocused) || button != MIDletProxy.BUTTON_MAIN)
		{
			return;
		}
		pointerFocused = false;
		pointerReleased(x, y);
	}

	void onTraverseOut()
	{
		traverseOut();
	}

	boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight,
			int[] visibleRectangle)
	{
		return traverse(direction, viewportWidth, viewportHeight, visibleRectangle);
	}

	boolean keyHandling(int key)
	{
		int keyCode;
		return (keyCode = MIDletProxy.getInstance().getKeyCode(key)) ==
				Canvas.KEY_STAR || keyCode == Canvas.KEY_POUND ||
				keyCode >= Canvas.KEY_NUM0 && keyCode <= Canvas.KEY_NUM9;
	}

	int getPreferredContentWidth(int contentHeight, int containerClientWidth)
	{
		return getPrefContentWidth(contentHeight);
	}

	int getPreferredContentHeight(int contentWidth)
	{
		return getPrefContentHeight(contentWidth);
	}

	int getMinimumContentWidth(int containerClientWidth)
	{
		return getMinContentWidth();
	}

	int getMinimumContentHeight()
	{
		return getMinContentHeight();
	}
}
