/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class TextOutput extends Object
{
	protected int length;
	protected char[] chars;

	public TextOutput()
	{
	}

	public TextOutput(int capacity)
	{
		this.chars = new char[capacity];
	}

	public String toString()
	{
		char[] c;
		return (c = chars) == null ? "" : (new String(c, 0, length)).intern();
	}

	public void clear()
	{
		length = 0;
	}

	public void setText(String text)
	{
		int len;
		char[] c;
		if(text == null || (len = text.length()) <= 0)
		{
			length = 0;
			return;
		}
		if(((c = chars) == null ? 0 : c.length) < len)
		{
			c = chars = new char[len];
		}
		text.getChars(0, len, c, 0);
		length = len;
	}

	public void append(String data)
	{
		int len;
		int length;
		int newLength;
		char[] c;
		if(data == null || (length = data.length()) <= 0)
		{
			return;
		}
		newLength = (len = this.length) + length;
		if((c = chars) == null)
		{
			c = chars = new char[length];
		}
		else if(newLength > c.length)
		{
			Array.copy(c, 0, c = chars = new char[Math.max(len << 1, newLength)], 0, len);
		}
		data.getChars(0, length, c, len);
		this.length = newLength;
	}

	public void append(char[] data, int offset, int length)
	{
		int len;
		int newLength;
		char[] c;
		if(data == null || length <= 0)
		{
			return;
		}
		newLength = (len = this.length) + length;
		if((c = chars) == null)
		{
			c = chars = new char[length];
		}
		else if(newLength > c.length)
		{
			Array.copy(c, 0, c = chars = new char[Math.max(len << 1, newLength)], 0, len);
		}
		Array.copy(data, offset, c, len, length);
		this.length = newLength;
	}

	public void append(int data, int radix, boolean upperCase)
	{
		int i;
		int len;
		int digit;
		int value;
		int newLength;
		int length;
		char[] c;
		if(radix < Character.MIN_RADIX || radix > Character.MAX_RADIX)
		{
			radix = 10;
		}
		if(data > 0)
		{
			length = 0;
			value = -data;
		} else
		{
			length = 1;
			value = data;
		}
		for(; value != 0; length++, value /= radix);
		newLength = (len = this.length) + length;
		if((c = chars) == null)
		{
			c = chars = new char[length];
		}
		else if(newLength > c.length)
		{
			Array.copy(c, 0, c = chars = new char[Math.max(len << 1, newLength)], 0, len);
		}
		for(value = data > 0 ? -data : data, i = newLength; i-- > len; value /= radix)
		{
			c[i] = (char) (data < 0 && i == len ? '-' : ((digit = -(value % radix)) < 10 ?
					digit + '0' : digit + (upperCase ? 'A' - 10 : 'a' - 10)));
		}
		this.length = newLength;
	}

	public final int getLength()
	{
		return length;
	}

	public final char[] getChars()
	{
		return chars;
	}
}
