/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class TextOutputMultilinedExt extends TextOutputMultilined
{
	private int width;
	private Font font;

	public TextOutputMultilinedExt()
	{
	}

	public TextOutputMultilinedExt(int capacity)
	{
		super(capacity);
	}

	public void clear()
	{
		super.clear();
		width = 0;
		font = null;
	}

	public void split(Font font, int width)
	{
		if(font == this.font && width == this.width)
		{
			return;
		}
		this.width = width;
		this.font = font;
		super.split(font, width);
	}

	public void setText(String text)
	{
		super.setText(text);
		width = 0;
		font = null;
	}

	public void append(String data)
	{
		super.append(data);
		if(data == null || data.length() == 0)
		{
			return;
		}
		width = 0;
		font = null;
	}

	public void append(char[] data, int offset, int length)
	{
		super.append(data, offset, length);
		if(length == 0)
		{
			return;
		}
		width = 0;
		font = null;
	}

	public void append(int data, int radix, boolean upperCase)
	{
		super.append(data, radix, upperCase);
		width = 0;
		font = null;
	}
}
