/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import malik.emulator.midp.*;
import malik.emulator.util.*;

public class SetEnableStackTraceCommand extends ConsoleCommand
{
	public SetEnableStackTraceCommand()
	{
		super("трассировка",
				"Использование:\n" +
				"  трассировка\n" +
				"  трассировка вкл\n" +
				"  трассировка выкл\n" +
				"  трассировка откл\n" +
				"Включает или выключает трассировку стека в исключениях. " +
				"Отключение трассировки стека позволяет повысить быстродействие приложения. " +
				"Вариант без аргументов – вывод на консоль текущего состояния.");
	}

	public void run(String[] arguments)
	{
		String argument;
		ConsoleScreen console;
		if((console = getConsoleScreen()) == null)
		{
			return;
		}
		if(arguments.length <= 0)
		{
			console.print(ThrowableStackTrace.enabled() ?
					"Трассировка стека сейчас включена.\n" :
					"Трассировка стека сейчас отключена.\n");
			return;
		}
		if("вкл".equals(argument = arguments[0]))
		{
			ThrowableStackTrace.enable(true);
			return;
		}
		if("выкл".equals(argument) || "откл".equals(argument))
		{
			ThrowableStackTrace.enable(false);
		}
	}
}
