/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.lang;

import malik.emulator.util.*;

public final class Integer extends Object
{
    public static final int MIN_VALUE = 0x80000000;
    public static final int MAX_VALUE = 0x7fffffff;

    public static int parseInt(String string) throws NumberFormatException {
        return parseInt(string, 10);
    }

    public static int parseInt(String string, int radix) throws NumberFormatException {
        boolean negative;
        int i;
        int len;
        int digit;
        int limit;
        int mulmin;
        int result;
        if(string == null || (len = string.length()) <= 0)
        {
            throw new NumberFormatException("Integer.parseInt: недопустимый формат числа.");
        }
        if(radix > Character.MAX_RADIX)
        {
            throw new NumberFormatException((new StringBuilder()).append("Integer.parseInt: основание системы счисления (").append(radix).append(") больше, чем Character.MAX_RADIX.").toString());
        }
        if(radix < Character.MIN_RADIX)
        {
            throw new NumberFormatException((new StringBuilder()).append("Integer.parseInt: основание системы счисления (").append(radix).append(") меньше, чем Character.MIN_RADIX.").toString());
        }
        result = 0;
        if(string.charAt(i = 0) == '-')
        {
            i++;
            negative = true;
            limit = 0x80000000;
        } else
        {
            negative = false;
            limit = 0x80000001;
        }
        mulmin = limit / radix;
        if(i < len)
        {
            if((digit = Character.digit(string.charAt(i++), radix)) < 0)
            {
                throw new NumberFormatException("Integer.parseInt: недопустимый формат числа.");
            }
            result = -digit;
        }
        while(i < len)
        {
            if((digit = Character.digit(string.charAt(i++), radix)) < 0 || result < mulmin || (result *= radix) < limit + digit)
            {
                throw new NumberFormatException("Integer.parseInt: недопустимый формат числа.");
            }
            result -= digit;
        }
        if(negative)
        {
            if(i <= 1)
            {
                throw new NumberFormatException("Integer.parseInt: недопустимый формат числа.");
            }
            return result;
        }
        return -result;
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        int value = parseInt(string, 10);
        return new Integer(value);
    }

    public static Integer valueOf(String string, int radix) throws NumberFormatException {
        int value = parseInt(string, radix);
        return new Integer(value);
    }

    public static String toString(int value) {
        return toString(value, 10);
    }

    public static String toString(int value, int radix) {
        boolean negative = value < 0;
        int i;
        int len = (i = 32) + 1;
        char[] buf = new char[len];
        if(radix > Character.MAX_RADIX || radix < Character.MIN_RADIX) radix = 10;
        if(!negative) value = -value;
        for(int negradix = -radix; value <= negradix; buf[i--] = Character.getDigitRepresentation(-(value % radix)), value /= radix);
        buf[i] = Character.getDigitRepresentation(-value);
        if(negative) buf[--i] = '-';
        return new String(buf, i, len - i);
    }

    public static String toBinaryString(int value) {
        return toUnsignedString(value, 1);
    }

    public static String toOctalString(int value) {
        return toUnsignedString(value, 3);
    }

    public static String toHexString(int value) {
        return toUnsignedString(value, 4);
    }

    private static String toUnsignedString(int value, int shift) {
        int i;
        int len = i = 32;
        int mask = (1 << shift) - 1;
        char[] buf = new char[len];
        do
        {
            buf[--i] = Character.getDigitRepresentation(value & mask);
        } while((value >>>= shift) != 0);
        return new String(buf, i, len - i);
    }

    private final int value;

    public Integer(int value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Integer && value == ((Integer) anot).value;
    }

    public int hashCode() {
        return value;
    }

    public String toString() {
        return toString(value, 10);
    }

    public float floatValue() {
        return (float) value;
    }

    public double doubleValue() {
        return (double) value;
    }

    public byte byteValue() {
        return (byte) value;
    }

    public short shortValue() {
        return (short) value;
    }

    public int intValue() {
        return value;
    }

    public long longValue() {
        return (long) value;
    }
}
